/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.DefaultStubBuilder");

    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTree"));
        }
        return this.buildStubTreeFor((PsiElement)file, this.createStubForFile(file));
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        PsiFileStubImpl<PsiFile> stub;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = stub = new PsiFileStubImpl<PsiFile>(file);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    @NotNull
    private StubElement buildStubTreeFor(@NotNull PsiElement root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStub", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        Stack parentStubs = new Stack();
        Stack parentElements = new Stack();
        parentElements.push((Object)root);
        parentStubs.push((Object)parentStub);
        while (!parentElements.isEmpty()) {
            StubElement stub = (StubElement)parentStubs.pop();
            PsiElement elt = (PsiElement)parentElements.pop();
            if (elt instanceof StubBasedPsiElement) {
                IStubElementType type = ((StubBasedPsiElement)elt).getElementType();
                if (type.shouldCreateStub(elt.getNode())) {
                    StubElement s;
                    stub = s = type.createStub(elt, stub);
                }
            } else {
                IElementType type;
                ASTNode node = elt.getNode();
                IElementType iElementType = type = node == null ? null : node.getElementType();
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(node)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + elt);
                }
            }
            for (PsiElement child = elt.getLastChild(); child != null; child = child.getPrevSibling()) {
                if (this.skipChildProcessingWhenBuildingStubs(elt, child)) continue;
                parentStubs.push((Object)stub);
                parentElements.push((Object)child);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        return stubElement;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    @NotNull
    protected StubElement buildStubTreeFor(@NotNull ASTNode root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStub", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        Stack parentStubs = new Stack();
        Stack parentNodes = new Stack();
        parentNodes.push((Object)root);
        parentStubs.push((Object)parentStub);
        while (!parentStubs.isEmpty()) {
            IStubElementType type;
            StubElement stub = (StubElement)parentStubs.pop();
            ASTNode node = (ASTNode)parentNodes.pop();
            IElementType nodeType = node.getElementType();
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                StubElement s;
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element);
                }
                LOG.assertTrue((stub = (s = type.createStub(element, stub))) != null, (Object)element);
            }
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (this.skipChildProcessingWhenBuildingStubs(node, childNode)) continue;
                parentNodes.push((Object)childNode);
                parentStubs.push((Object)stub);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        return stubElement;
    }

    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }
}

