/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.Iterator;
import java.util.Set;

class OptimizeImportsTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance((String)("#" + OptimizeImportsTask.class.getName()));
    private final Iterator<SmartPsiElementPointer<PsiImportStatementBase>> myPointers;
    private final SequentialModalProgressTask myTask;
    private final int myTotal;
    private int myCount;

    public OptimizeImportsTask(SequentialModalProgressTask progressTask, Set<SmartPsiElementPointer<PsiImportStatementBase>> pointers) {
        this.myTask = progressTask;
        this.myTotal = pointers.size();
        this.myPointers = pointers.iterator();
    }

    public void prepare() {
    }

    public boolean isDone() {
        return !this.myPointers.hasNext();
    }

    public boolean iteration() {
        PsiElement resolve;
        PsiJavaCodeReferenceElement ref;
        SmartPsiElementPointer<PsiImportStatementBase> pointer;
        PsiImportStatementBase importStatement;
        ProgressIndicator indicator = this.myTask.getIndicator();
        if (indicator != null) {
            indicator.setFraction((double)this.myCount++ / (double)this.myTotal);
        }
        if ((importStatement = (PsiImportStatementBase)(pointer = this.myPointers.next()).getElement()) != null && importStatement.isValid() && (ref = importStatement.getImportReference()) != null && (resolve = ref.resolve()) != null && (!(resolve instanceof PsiPackage) || ((PsiPackage)resolve).getDirectories(ref.getResolveScope()).length != 0)) {
            try {
                importStatement.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.isDone();
    }

    public void stop() {
    }
}

