/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsWithSearchSettingsDialog;
import com.intellij.refactoring.inline.InlineToAnonymousClassProcessor;

public class InlineToAnonymousClassDialog
extends InlineOptionsWithSearchSettingsDialog {
    private final PsiClass myClass;
    private final PsiCall myCallToInline;

    protected InlineToAnonymousClassDialog(Project project, PsiClass psiClass, PsiCall callToInline, boolean isInvokeOnReference) {
        super(project, true, (PsiElement)psiClass);
        this.myClass = psiClass;
        this.myCallToInline = callToInline;
        this.myInvokedOnReference = isInvokeOnReference;
        this.setTitle(RefactoringBundle.message((String)"inline.to.anonymous.refactoring"));
        this.init();
    }

    @Override
    protected String getNameLabelText() {
        String className = PsiFormatUtil.formatClass((PsiClass)this.myClass, (int)1);
        return RefactoringBundle.message((String)"inline.to.anonymous.name.label", (Object[])new Object[]{className});
    }

    @Override
    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.to.anonymous.border.title");
    }

    @Override
    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.references.and.remove.the.class");
    }

    @Override
    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.the.class");
    }

    @Override
    protected boolean isInlineThis() {
        return false;
    }

    @Override
    protected boolean isSearchInCommentsAndStrings() {
        return JavaRefactoringSettings.getInstance().INLINE_CLASS_SEARCH_IN_COMMENTS;
    }

    @Override
    protected boolean isSearchForTextOccurrences() {
        return JavaRefactoringSettings.getInstance().INLINE_CLASS_SEARCH_IN_NON_JAVA;
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.invokeRefactoring(new InlineToAnonymousClassProcessor(this.getProject(), this.myClass, this.myCallToInline, this.isInlineThisOnly(), this.isSearchInCommentsAndStrings(), this.isSearchForTextOccurrences()));
    }

    @Override
    protected void saveSearchInCommentsAndStrings(boolean searchInComments) {
        JavaRefactoringSettings.getInstance().INLINE_CLASS_SEARCH_IN_COMMENTS = searchInComments;
    }

    @Override
    protected void saveSearchInTextOccurrences(boolean searchInTextOccurrences) {
        JavaRefactoringSettings.getInstance().INLINE_CLASS_SEARCH_IN_NON_JAVA = searchInTextOccurrences;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.inlineClass");
    }
}

