/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class AutomaticOverloadsRenamer
extends AutomaticRenamer {
    public AutomaticOverloadsRenamer(PsiMethod method, String newName) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null) {
            PsiMethod[] overloads;
            for (PsiMethod overload : overloads = containingClass.findMethodsByName(method.getName(), false)) {
                if (overload == method) continue;
                this.myElements.add(overload);
                this.suggestAllNames(overload.getName(), newName);
            }
        }
    }

    @Override
    public String getDialogTitle() {
        return "Rename Overloads";
    }

    @Override
    public String getDialogDescription() {
        return "Rename overloads to:";
    }

    @Override
    public String entityName() {
        return "Overload";
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }
}

