/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.text.UniqueNameGenerator;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class CloudConfigurableBase<SC extends CloudConfigurationBase>
extends RemoteServerConfigurable {
    private final ServerType<SC> myCloudType;
    protected final SC myConfiguration;

    public CloudConfigurableBase(ServerType<SC> cloudType, SC configuration) {
        this.myCloudType = cloudType;
        this.myConfiguration = configuration;
    }

    protected final ServerType<SC> getCloudType() {
        return this.myCloudType;
    }

    @Nullable
    public JComponent createComponent() {
        return this.getMainPanel();
    }

    public boolean isModified() {
        return !this.getEmailTextField().getText().equals(((CloudConfigurationBase)((Object)this.myConfiguration)).getEmail()) || !new String(this.getPasswordField().getPassword()).equals(((CloudConfigurationBase)((Object)this.myConfiguration)).getPassword());
    }

    public void apply() throws ConfigurationException {
        this.applyCoreTo(this.myConfiguration);
    }

    public void reset() {
        this.getEmailTextField().setText(((CloudConfigurationBase)((Object)this.myConfiguration)).getEmail());
        this.getPasswordField().setText(((CloudConfigurationBase)((Object)this.myConfiguration)).getPassword());
    }

    protected void applyCoreTo(SC configuration) throws ConfigurationException {
        String email = this.getEmailTextField().getText();
        if (StringUtil.isEmpty((String)email)) {
            throw new RuntimeConfigurationError("Email required");
        }
        String password = new String(this.getPasswordField().getPassword());
        if (StringUtil.isEmpty((String)password)) {
            throw new RuntimeConfigurationError("Password required");
        }
        ((CloudConfigurationBase)((Object)configuration)).setEmail(email);
        ((CloudConfigurationBase)((Object)configuration)).setPassword(password);
    }

    protected boolean isCoreConfigEqual(SC configuration1, SC configuration2) {
        return Comparing.equal((String)((CloudConfigurationBase)((Object)configuration1)).getEmail(), (String)((CloudConfigurationBase)((Object)configuration2)).getEmail()) && Comparing.equal((String)((CloudConfigurationBase)((Object)configuration1)).getPassword(), (String)((CloudConfigurationBase)((Object)configuration2)).getPassword());
    }

    private String generateServerName() {
        return UniqueNameGenerator.generateUniqueName((String)this.myCloudType.getPresentableName(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                for (RemoteServer server : RemoteServersManager.getInstance().getServers()) {
                    if (!server.getName().equals(s)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    protected final RemoteServer<SC> createTempServer() {
        RemoteServer tempServer = RemoteServersManager.getInstance().createServer(this.myCloudType, this.generateServerName());
        CloudConfigurationBase newConfiguration = (CloudConfigurationBase)tempServer.getConfiguration();
        try {
            this.applyCoreTo(newConfiguration);
        }
        catch (ConfigurationException e) {
            return null;
        }
        return tempServer;
    }

    protected abstract JComponent getMainPanel();

    protected abstract JTextField getEmailTextField();

    protected abstract JPasswordField getPasswordField();
}

