/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UsageViewContext {
    protected final SearchContext mySearchContext;
    private final Runnable mySearchStarter;
    private UsageView myUsageView;
    protected final Configuration myConfiguration;
    private Set<Usage> myExcludedSet;

    protected UsageViewContext(Configuration configuration, SearchContext searchContext, Runnable searchStarter) {
        this.myConfiguration = configuration;
        this.mySearchContext = searchContext;
        this.mySearchStarter = searchStarter;
    }

    public boolean isExcluded(Usage usage) {
        if (this.myExcludedSet == null) {
            this.myExcludedSet = this.myUsageView.getExcludedUsages();
        }
        return this.myExcludedSet.contains(usage);
    }

    public UsageView getUsageView() {
        return this.myUsageView;
    }

    public void setUsageView(UsageView usageView) {
        this.myUsageView = usageView;
    }

    public ConfigurableUsageTarget getTarget() {
        return new MyUsageTarget();
    }

    public void configure(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/structuralsearch/plugin/ui/UsageViewContext", "configure"));
        }
        String pattern = this.myConfiguration.getMatchOptions().getSearchPattern();
        String scopeText = this.myConfiguration.getMatchOptions().getScope().getDisplayName();
        presentation.setScopeText(scopeText);
        String usagesString = SSRBundle.message("occurrences.of", pattern);
        presentation.setUsagesString(usagesString);
        presentation.setTabText(StringUtil.shortenTextWithEllipsis((String)usagesString, (int)60, (int)0, (boolean)false));
        presentation.setUsagesWord(SSRBundle.message("occurrence", new Object[0]));
        presentation.setCodeUsagesString(SSRBundle.message("found.occurrences", scopeText));
        presentation.setTargetsNodeText(SSRBundle.message("targets.node.text", new Object[0]));
        presentation.setCodeUsages(false);
    }

    protected void configureActions() {
    }

    private class MyUsageTarget
    implements ConfigurableUsageTarget,
    ItemPresentation {
        private MyUsageTarget() {
        }

        @NotNull
        public String getPresentableText() {
            String string = UsageViewContext.this.myConfiguration.getMatchOptions().getSearchPattern();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/UsageViewContext$MyUsageTarget", "getPresentableText"));
            }
            return string;
        }

        public String getLocationString() {
            return "Do Not Know Where";
        }

        public Icon getIcon(boolean open2) {
            return null;
        }

        public void findUsages() {
            UsageViewContext.this.mySearchStarter.run();
        }

        public void findUsagesInEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/UsageViewContext$MyUsageTarget", "findUsagesInEditor"));
            }
            throw new UnsupportedOperationException();
        }

        public void highlightUsages(@NotNull PsiFile file, @NotNull Editor editor, boolean clearHighlights) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/structuralsearch/plugin/ui/UsageViewContext$MyUsageTarget", "highlightUsages"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/UsageViewContext$MyUsageTarget", "highlightUsages"));
            }
            throw new UnsupportedOperationException();
        }

        public boolean isValid() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        public VirtualFile[] getFiles() {
            return null;
        }

        public void update() {
        }

        public String getName() {
            return "my name";
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public void navigate(boolean requestFocus) {
            throw new UnsupportedOperationException();
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public void showSettings() {
            UIUtil.invokeAction(UsageViewContext.this.myConfiguration, UsageViewContext.this.mySearchContext);
        }

        public KeyboardShortcut getShortcut() {
            return ActionManager.getInstance().getKeyboardShortcut(UsageViewContext.this.myConfiguration instanceof ReplaceConfiguration ? "StructuralSearchPlugin.StructuralReplaceAction" : "StructuralSearchPlugin.StructuralSearchAction");
        }

        @NotNull
        public String getLongDescriptiveName() {
            String result2;
            MatchOptions matchOptions = UsageViewContext.this.myConfiguration.getMatchOptions();
            String pattern = matchOptions.getSearchPattern();
            String scope = matchOptions.getScope().getDisplayName();
            if (UsageViewContext.this.myConfiguration instanceof ReplaceConfiguration) {
                ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)UsageViewContext.this.myConfiguration;
                String replacement = replaceConfiguration.getOptions().getReplacement();
                result2 = SSRBundle.message("replace.occurrences.of.0.with.1.in.2", pattern, replacement, scope);
            } else {
                result2 = SSRBundle.message("occurrences.of.0.in.1", pattern, scope);
            }
            String string = StringUtil.shortenTextWithEllipsis((String)result2, (int)150, (int)0, (boolean)true);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/UsageViewContext$MyUsageTarget", "getLongDescriptiveName"));
            }
            return string;
        }
    }
}

