/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.builders.EmptyModuleFixtureBuilder;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.BareTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.BareTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.EmptyModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.HeavyTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.LightIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.LightTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class IdeaTestFixtureFactoryImpl
extends IdeaTestFixtureFactory {
    protected final Map<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>> myFixtureBuilderProviders = new HashMap<Class<? extends ModuleFixtureBuilder>, Class<? extends ModuleFixtureBuilder>>();

    public IdeaTestFixtureFactoryImpl() {
        this.registerFixtureBuilder(EmptyModuleFixtureBuilder.class, MyEmptyModuleFixtureBuilderImpl.class);
    }

    @Override
    public final <T extends ModuleFixtureBuilder> void registerFixtureBuilder(@NotNull Class<T> aClass, @NotNull Class<? extends T> implClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "registerFixtureBuilder"));
        }
        if (implClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implClass", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "registerFixtureBuilder"));
        }
        this.myFixtureBuilderProviders.put(aClass, implClass);
    }

    @Override
    public void registerFixtureBuilder(@NotNull Class<? extends ModuleFixtureBuilder> aClass, @NotNull String implClassName) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "registerFixtureBuilder"));
        }
        if (implClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implClassName", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "registerFixtureBuilder"));
        }
        try {
            Class<?> implClass = Class.forName(implClassName);
            Assert.assertTrue((boolean)aClass.isAssignableFrom(implClass));
            this.registerFixtureBuilder(aClass, implClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot instantiate fixture builder implementation", e);
        }
    }

    @Override
    @NotNull
    public TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createFixtureBuilder"));
        }
        HeavyTestFixtureBuilderImpl heavyTestFixtureBuilderImpl = new HeavyTestFixtureBuilderImpl(new HeavyIdeaTestFixtureImpl(name), this.myFixtureBuilderProviders);
        if (heavyTestFixtureBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createFixtureBuilder"));
        }
        return heavyTestFixtureBuilderImpl;
    }

    @Override
    @NotNull
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder() {
        TestFixtureBuilder<IdeaProjectTestFixture> testFixtureBuilder = this.createLightFixtureBuilder(null);
        if (testFixtureBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createLightFixtureBuilder"));
        }
        return testFixtureBuilder;
    }

    @Override
    @NotNull
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder(@Nullable LightProjectDescriptor projectDescriptor) {
        if (projectDescriptor == null) {
            projectDescriptor = LightProjectDescriptor.EMPTY_PROJECT_DESCRIPTOR;
        }
        LightTestFixtureBuilderImpl<IdeaProjectTestFixture> lightTestFixtureBuilderImpl = new LightTestFixtureBuilderImpl<IdeaProjectTestFixture>(new LightIdeaTestFixtureImpl(projectDescriptor));
        if (lightTestFixtureBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createLightFixtureBuilder"));
        }
        return lightTestFixtureBuilderImpl;
    }

    @Override
    @NotNull
    public CodeInsightTestFixture createCodeInsightFixture(@NotNull IdeaProjectTestFixture projectFixture) {
        if (projectFixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFixture", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createCodeInsightFixture"));
        }
        CodeInsightTestFixture codeInsightTestFixture = this.createCodeInsightFixture(projectFixture, new TempDirTestFixtureImpl());
        if (codeInsightTestFixture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createCodeInsightFixture"));
        }
        return codeInsightTestFixture;
    }

    @Override
    @NotNull
    public CodeInsightTestFixture createCodeInsightFixture(@NotNull IdeaProjectTestFixture projectFixture, @NotNull TempDirTestFixture tempDirFixture) {
        if (projectFixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFixture", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createCodeInsightFixture"));
        }
        if (tempDirFixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirFixture", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createCodeInsightFixture"));
        }
        CodeInsightTestFixtureImpl codeInsightTestFixtureImpl = new CodeInsightTestFixtureImpl(projectFixture, tempDirFixture);
        if (codeInsightTestFixtureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createCodeInsightFixture"));
        }
        return codeInsightTestFixtureImpl;
    }

    @Override
    @NotNull
    public TempDirTestFixture createTempDirTestFixture() {
        TempDirTestFixtureImpl tempDirTestFixtureImpl = new TempDirTestFixtureImpl();
        if (tempDirTestFixtureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createTempDirTestFixture"));
        }
        return tempDirTestFixtureImpl;
    }

    @Override
    @NotNull
    public BareTestFixture createBareFixture() {
        BareTestFixtureImpl bareTestFixtureImpl = new BareTestFixtureImpl();
        if (bareTestFixtureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/IdeaTestFixtureFactoryImpl", "createBareFixture"));
        }
        return bareTestFixtureImpl;
    }

    public static class MyEmptyModuleFixtureBuilderImpl
    extends EmptyModuleFixtureBuilderImpl {
        public MyEmptyModuleFixtureBuilderImpl(TestFixtureBuilder<? extends IdeaProjectTestFixture> testFixtureBuilder) {
            super(testFixtureBuilder);
        }

        @Override
        protected ModuleFixture instantiateFixture() {
            return new ModuleFixtureImpl(this);
        }
    }
}

