/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ListExpandableItemsHandler;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SelectionSaver;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TableExpandableItemsHandler;
import com.intellij.ui.TreeExpandableItemsHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.Convertor;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeUIHelperImpl
extends TreeUIHelper {
    public void installToolTipHandler(JTree tree) {
        if (tree instanceof Tree) {
            return;
        }
        new TreeExpandableItemsHandler(tree);
    }

    public void installToolTipHandler(JTable table) {
        if (table instanceof JBTable) {
            return;
        }
        new TableExpandableItemsHandler(table);
    }

    public void installToolTipHandler(JList list) {
        if (list instanceof JBList) {
            return;
        }
        new ListExpandableItemsHandler(list);
    }

    public void installEditSourceOnDoubleClick(JTree tree) {
        EditSourceOnDoubleClickHandler.install((JTree)tree);
    }

    public void installTreeSpeedSearch(JTree tree) {
        new TreeSpeedSearch(tree);
    }

    public void installTreeSpeedSearch(JTree tree, Convertor<TreePath, String> convertor, boolean canExpand) {
        new TreeSpeedSearch(tree, convertor, canExpand);
    }

    public void installListSpeedSearch(JList list) {
        new ListSpeedSearch(list);
    }

    public void installListSpeedSearch(JList list, Convertor<Object, String> convertor) {
        new ListSpeedSearch(list, convertor);
    }

    public void installEditSourceOnEnterKeyHandler(JTree tree) {
        EditSourceOnEnterKeyHandler.install((JTree)tree);
    }

    public void installSmartExpander(JTree tree) {
        SmartExpander.installOn((JTree)tree);
    }

    public void installSelectionSaver(JTree tree) {
        SelectionSaver.installOn(tree);
    }
}

