/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndexImpl;

class ProjectFilesCondition
implements Condition<VirtualFile> {
    private static final int MAX_FILES_TO_UPDATE_FROM_OTHER_PROJECT = 2;
    private final VirtualFile myRestrictedTo;
    private final GlobalSearchScope myFilter;
    private int myFilesFromOtherProjects;
    private final FileBasedIndexImpl.ProjectIndexableFilesFilter myIndexableFilesFilter;

    public ProjectFilesCondition(FileBasedIndexImpl.ProjectIndexableFilesFilter indexableFilesFilter, GlobalSearchScope filter, VirtualFile restrictedTo, boolean includeFilesFromOtherProjects) {
        this.myRestrictedTo = restrictedTo;
        this.myFilter = filter;
        this.myIndexableFilesFilter = indexableFilesFilter;
        if (!includeFilesFromOtherProjects) {
            this.myFilesFromOtherProjects = 2;
        }
    }

    public boolean value(VirtualFile file) {
        if (this.myIndexableFilesFilter != null && !this.myIndexableFilesFilter.containsFileId(((VirtualFileWithId)file).getId())) {
            if (this.myFilesFromOtherProjects >= 2) {
                return false;
            }
            ++this.myFilesFromOtherProjects;
            return true;
        }
        if (FileBasedIndexImpl.belongsToScope(file, this.myRestrictedTo, this.myFilter)) {
            return true;
        }
        if (this.myFilesFromOtherProjects < 2) {
            ++this.myFilesFromOtherProjects;
            return true;
        }
        return false;
    }
}

