/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class XmlIndex<V>
extends FileBasedIndexExtension<String, V> {
    protected static final EnumeratorStringDescriptor KEY_DESCRIPTOR = new EnumeratorStringDescriptor();

    protected static GlobalSearchScope createFilter(Project project) {
        final GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)project);
        return new GlobalSearchScope(project){

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/xml/index/XmlIndex$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/xml/index/XmlIndex$1", "compare"));
                }
                return projectScope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/xml/index/XmlIndex$1", "isSearchInModuleContent"));
                }
                return true;
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlIndex$1", "contains"));
                }
                VirtualFile parent = file.getParent();
                return parent != null && (parent.getName().equals("standardSchemas") || projectScope.contains(file));
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }

    protected static VirtualFileFilter createFilter(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/xml/index/XmlIndex", "createFilter"));
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        return new VirtualFileFilter(){

            public boolean accept(VirtualFile file) {
                Module moduleForFile = fileIndex.getModuleForFile(file);
                if (moduleForFile != null) {
                    return module.equals(moduleForFile);
                }
                if (fileIndex.isInLibraryClasses(file)) {
                    List orderEntries = fileIndex.getOrderEntriesForFile(file);
                    if (orderEntries.isEmpty()) {
                        return false;
                    }
                    for (OrderEntry orderEntry : orderEntries) {
                        Module ownerModule = orderEntry.getOwnerModule();
                        if (!ownerModule.equals(module)) continue;
                        return true;
                    }
                }
                VirtualFile parent = file.getParent();
                assert (parent != null);
                return parent.getName().equals("standardSchemas");
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = KEY_DESCRIPTOR;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE, DTDFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlIndex$3", "acceptInput"));
                }
                FileType fileType = file.getFileType();
                String extension = file.getExtension();
                return XmlFileType.INSTANCE.equals(fileType) && "xsd".equals(extension) || ((Object)((Object)DTDFileType.INSTANCE)).equals(fileType) && "dtd".equals(extension);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }
}

