/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogStatementGuardedByLogConditionInspectionBase
extends BaseInspection {
    final List<String> logMethodNameList = new ArrayList<String>();
    final List<String> logConditionMethodNameList = new ArrayList<String>();
    public String loggerClassName = "java.util.logging.Logger";
    @NonNls
    public String loggerMethodAndconditionMethodNames = "fine,isLoggable(java.util.logging.Level.FINE),finer,isLoggable(java.util.logging.Level.FINER),finest,isLoggable(java.util.logging.Level.FINEST)";
    public boolean flagAllUnguarded = false;

    public LogStatementGuardedByLogConditionInspectionBase() {
        LogStatementGuardedByLogConditionInspectionBase.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LogStatementGuardedByLogConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LogStatementGuardedByLogConditionVisitor();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        LogStatementGuardedByLogConditionInspectionBase.parseString(this.loggerMethodAndconditionMethodNames, this.logMethodNameList, this.logConditionMethodNameList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase", "writeSettings"));
        }
        this.loggerMethodAndconditionMethodNames = LogStatementGuardedByLogConditionInspectionBase.formatString(this.logMethodNameList, this.logConditionMethodNameList);
        super.writeSettings(element);
    }

    private class LogStatementGuardedByLogConditionVisitor
    extends BaseInspectionVisitor {
        private LogStatementGuardedByLogConditionVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.contains(referenceName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName)) {
                return;
            }
            if (this.isSurroundedByLogGuard((PsiElement)expression, referenceName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            if (!LogStatementGuardedByLogConditionInspectionBase.this.flagAllUnguarded) {
                boolean constant = true;
                for (PsiExpression argument : arguments) {
                    if (PsiUtil.isConstantExpression((PsiExpression)argument)) continue;
                    constant = false;
                    break;
                }
                if (constant) {
                    return;
                }
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private boolean isSurroundedByLogGuard(PsiElement element, String logMethodName) {
            PsiIfStatement ifStatement;
            while ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) != null) {
                PsiExpression condition = ifStatement.getCondition();
                if (this.isLogGuardCheck(condition, logMethodName)) {
                    return true;
                }
                element = ifStatement;
            }
            return false;
        }

        private boolean isLogGuardCheck(@Nullable PsiExpression expression, String logMethodName) {
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return false;
                }
                if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName)) {
                    return false;
                }
                String referenceName = methodExpression.getReferenceName();
                if (referenceName == null) {
                    return false;
                }
                int index = LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.indexOf(logMethodName);
                String conditionName = LogStatementGuardedByLogConditionInspectionBase.this.logConditionMethodNameList.get(index);
                return conditionName.startsWith(referenceName);
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiExpression[] operands;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    if (!this.isLogGuardCheck(operand, logMethodName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class LogStatementGuardedByLogConditionFix
    extends InspectionGadgetsFix {
        private LogStatementGuardedByLogConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase$LogStatementGuardedByLogConditionFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("log.statement.guarded.by.log.condition.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase$LogStatementGuardedByLogConditionFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element.getParent().getParent();
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
            if (statement == null) {
                return;
            }
            ArrayList<PsiStatement> logStatements = new ArrayList<PsiStatement>();
            logStatements.add(statement);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (previousStatement != null && this.isSameLogMethodCall(previousStatement, referenceName)) {
                logStatements.add(0, previousStatement);
                previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)previousStatement, PsiStatement.class);
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            while (nextStatement != null && this.isSameLogMethodCall(nextStatement, referenceName)) {
                logStatements.add(nextStatement);
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            int index = LogStatementGuardedByLogConditionInspectionBase.this.logMethodNameList.indexOf(referenceName);
            String conditionMethodText = LogStatementGuardedByLogConditionInspectionBase.this.logConditionMethodNameList.get(index);
            String ifStatementText = "if (" + qualifier.getText() + '.' + conditionMethodText + ") {}";
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(ifStatementText, (PsiElement)statement);
            PsiBlockStatement blockStatement = (PsiBlockStatement)ifStatement.getThenBranch();
            if (blockStatement == null) {
                return;
            }
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement logStatement : logStatements) {
                codeBlock.add((PsiElement)logStatement);
            }
            PsiStatement firstStatement = (PsiStatement)logStatements.get(0);
            PsiElement parent = firstStatement.getParent();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() != null) {
                PsiBlockStatement newBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)statement);
                newBlockStatement.getCodeBlock().add((PsiElement)ifStatement);
                PsiElement result2 = firstStatement.replace((PsiElement)newBlockStatement);
                codeStyleManager.shortenClassReferences(result2);
                return;
            }
            PsiElement result3 = parent.addBefore((PsiElement)ifStatement, (PsiElement)firstStatement);
            codeStyleManager.shortenClassReferences(result3);
            for (PsiStatement logStatement : logStatements) {
                logStatement.delete();
            }
        }

        private boolean isSameLogMethodCall(PsiStatement statement, @NotNull String methodName) {
            if (methodName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/siyeh/ig/logging/LogStatementGuardedByLogConditionInspectionBase$LogStatementGuardedByLogConditionFix", "isSameLogMethodCall"));
            }
            if (statement == null) {
                return false;
            }
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!methodName.equals(referenceName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            return qualifier != null && TypeUtils.expressionHasTypeOrSubtype(qualifier, LogStatementGuardedByLogConditionInspectionBase.this.loggerClassName);
        }
    }
}

