/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.intention.CheckRegExpForm;
import org.jetbrains.annotations.NotNull;

public class CheckRegExpIntentionAction
extends QuickEditAction
implements Iconable {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/regexp/intention/CheckRegExpIntentionAction", "isAvailable"));
        }
        Pair<PsiElement, TextRange> pair = this.getRangePair(file, editor);
        if (pair != null && pair.first != null) {
            Language language = ((PsiElement)pair.first).getLanguage();
            return language.isKindOf((Language)RegExpLanguage.INSTANCE);
        }
        return false;
    }

    @Override
    protected boolean isShowInBalloon() {
        return true;
    }

    @Override
    protected JComponent createBalloonComponent(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/regexp/intention/CheckRegExpIntentionAction", "createBalloonComponent"));
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document != null) {
            return new CheckRegExpForm(file).getRootPanel();
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        if ("Check RegExp" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/intention/CheckRegExpIntentionAction", "getText"));
        }
        return "Check RegExp";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/intention/CheckRegExpIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return RegExpLanguage.INSTANCE.getAssociatedFileType().getIcon();
    }
}

