/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import org.jetbrains.annotations.NotNull;

public enum ValueType {
    OBJECT,
    NUMBER,
    STRING,
    FUNCTION,
    BOOLEAN,
    ARRAY,
    NODE,
    UNDEFINED,
    NULL;

    private static final ValueType[] VALUE_TYPES;

    @NotNull
    public static ValueType fromIndex(int index) {
        ValueType valueType = VALUE_TYPES[index];
        if (valueType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueType", "fromIndex"));
        }
        return valueType;
    }

    public boolean isObjectType() {
        return this == OBJECT || this == ARRAY || this == FUNCTION || this == NODE;
    }

    static {
        VALUE_TYPES = ValueType.values();
    }
}

