/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.stream.JsonReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ModalityState;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

public class JetBrainsProtocolHandlerHttpService
extends RestService {
    private static final String URL_PARAM_NAME = "url";

    @Override
    @NotNull
    protected String getServiceName() {
        if ("internal" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/JetBrainsProtocolHandlerHttpService", "getServiceName"));
        }
        return "internal";
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/ide/JetBrainsProtocolHandlerHttpService", "isMethodSupported"));
        }
        return method == HttpMethod.POST;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/JetBrainsProtocolHandlerHttpService", "execute"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/JetBrainsProtocolHandlerHttpService", "execute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/JetBrainsProtocolHandlerHttpService", "execute"));
        }
        JsonReader reader = JetBrainsProtocolHandlerHttpService.createJsonReader(request);
        reader.beginObject();
        String name = reader.nextName();
        String url = reader.nextString();
        reader.endObject();
        if (URL_PARAM_NAME.equals(name) && url != null && url.startsWith("jetbrains://")) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)url);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    JBProtocolCommand.handleCurrentCommand();
                }
            }, ModalityState.any());
        }
        JetBrainsProtocolHandlerHttpService.sendOk(request, context);
        return null;
    }
}

