/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiRequestKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001E\u0007\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1\u0001\u0007\u00013\u0005A\n!)\u0006\n\u0007!\tQ\"\u0001M\u0002\u0013\rA!!D\u0001\u0019\u0006E\u001b\u0011\u0001C\u0002&\u0019!-Q\"\u0001\r\u00073\rAi!D\u0001\u0019\u000fe!\u0001rB\u0007\u0003\u0019\u0003A\u0002\"J\u0006\t\u00125\t\u0001DB\r\u0004\u0011%i\u0011\u0001g\u0005\u001a\u0007!QQ\"\u0001\r\tKA!\u0011\u0001#\u0006\u000e\u0003a1\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t\u00175\t\u00014A\r\u0004\u0011/i\u0011\u0001g\u0001&\u0017!aQ\"\u0001\r\u00073\rAI\"D\u0001\u0019\u001be\u0019\u00012D\u0007\u000219)C\u0002#\b\u000e\u0003a1\u0011\u0004\u0002\u0005\u0010\u001b\ta\t\u0001\u0007\u0003\u001a\u0007!}Q\"\u0001\r\u000fS!!\u0011\t\bE\u0004\u001b\ta\t\u0001\u0007\u0003R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0007\"A\u0011!D\u0001\u0019\u0004E\u001bA!\u0002\u0001\u000e\u0005\u0011%\u0001\"\u0002"}, strings={"Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "", "requestId", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "(ILio/netty/buffer/ByteBufAllocator;)V", "buffer", "Lio/netty/buffer/ByteBuf;", "getRequestId", "()I", "addHeader", "", "key", "", "value", "", "writeFileHeaders", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalRequestPath", "writeHeader", "type", "length", "writeHeaders", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "clientChannel", "Lio/netty/channel/Channel;", "writeToServerChannel", "content", "fastCgiChannel"}, moduleName="built-in-server")
public final class FastCgiRequest {
    private ByteBuf buffer;
    private final int requestId;

    public final void writeFileHeaders(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalRequestPath) {
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
        VirtualFile root = pathInfo.getRoot();
        this.addHeader("DOCUMENT_ROOT", FileUtil.toSystemDependentName((String)root.getPath()));
        this.addHeader("SCRIPT_FILENAME", pathInfo.getFilePath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    public final void addHeader(@NotNull String key, @Nullable CharSequence value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (value == null) {
            return;
        }
        int keyLength = key.length();
        int valLength = value.length();
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            Intrinsics.throwNpe();
        }
        this.writeHeader(byteBuf, FastCgiRequestKt.access$getPARAMS$p(), keyLength + valLength + (keyLength < 128 ? 1 : 4) + (valLength < 128 ? 1 : 4));
        if (keyLength < 128) {
            ByteBuf byteBuf2 = this.buffer;
            if (byteBuf2 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf2.writeByte(keyLength);
        } else {
            ByteBuf byteBuf3 = this.buffer;
            if (byteBuf3 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf3.writeByte(0x80 | keyLength >> 24);
            ByteBuf byteBuf4 = this.buffer;
            if (byteBuf4 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf4.writeByte(keyLength >> 16);
            ByteBuf byteBuf5 = this.buffer;
            if (byteBuf5 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf5.writeByte(keyLength >> 8);
            ByteBuf byteBuf6 = this.buffer;
            if (byteBuf6 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf6.writeByte(keyLength);
        }
        if (valLength < 128) {
            ByteBuf byteBuf7 = this.buffer;
            if (byteBuf7 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf7.writeByte(valLength);
        } else {
            ByteBuf byteBuf8 = this.buffer;
            if (byteBuf8 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf8.writeByte(0x80 | valLength >> 24);
            ByteBuf byteBuf9 = this.buffer;
            if (byteBuf9 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf9.writeByte(valLength >> 16);
            ByteBuf byteBuf10 = this.buffer;
            if (byteBuf10 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf10.writeByte(valLength >> 8);
            ByteBuf byteBuf11 = this.buffer;
            if (byteBuf11 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf11.writeByte(valLength);
        }
        ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)key);
        ByteBufUtilEx.writeUtf8(this.buffer, value);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeHeaders(@NotNull FullHttpRequest request, @NotNull Channel clientChannel) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)clientChannel, (String)"clientChannel");
        this.addHeader("REQUEST_URI", request.uri());
        this.addHeader("REQUEST_METHOD", request.method().name());
        SocketAddress socketAddress = clientChannel.remoteAddress();
        if (socketAddress == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress remote = (InetSocketAddress)socketAddress;
        this.addHeader("REMOTE_ADDR", remote.getAddress().getHostAddress());
        this.addHeader("REMOTE_PORT", Integer.toString(remote.getPort()));
        SocketAddress socketAddress2 = clientChannel.localAddress();
        if (socketAddress2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress local = (InetSocketAddress)socketAddress2;
        this.addHeader("SERVER_SOFTWARE", Responses.getServerHeaderValue());
        this.addHeader("SERVER_NAME", Responses.getServerHeaderValue());
        this.addHeader("SERVER_ADDR", local.getAddress().getHostAddress());
        this.addHeader("SERVER_PORT", Integer.toString(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request.protocolVersion().text());
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        int queryIndex = StringsKt.indexOf$default((CharSequence)request.uri(), (char)'?', (int)0, (boolean)false, (int)6);
        if (queryIndex != -1) {
            queryString = StringsKt.substring((String)request.uri(), (int)(queryIndex + 1));
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request.content().readableBytes()));
        Iterator iterator = CollectionsKt.iterator((Iterator)request.headers().iteratorAsString());
        while (iterator.hasNext()) {
            void $receiver;
            void $receiver2;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            String key = (String)$receiver2.getKey();
            Map.Entry $i$f$component1 = entry;
            String value = (String)$receiver.getValue();
            if (StringsKt.equals((String)key, (String)"keep-alive", (boolean)true)) continue;
            StringBuilder stringBuilder = new StringBuilder().append("HTTP_");
            String string = StringsKt.replace$default((String)key, (char)'-', (char)'_', (boolean)false, (int)4);
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            this.addHeader(stringBuilder.append(StringsKt.toUpperCase((String)string, (Locale)locale)).toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToServerChannel(@Nullable ByteBuf content, @NotNull Channel fastCgiChannel) {
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)fastCgiChannel, (String)"fastCgiChannel");
            if (fastCgiChannel.pipeline().first() == null) {
                throw (Throwable)new IllegalStateException("No handler in the pipeline");
            }
            boolean releaseContent = content != null;
            try {
                ByteBuf byteBuf = this.buffer;
                if (byteBuf == null) {
                    Intrinsics.throwNpe();
                }
                this.writeHeader(byteBuf, FastCgiRequestKt.access$getPARAMS$p(), 0);
                if (content != null) {
                    ByteBuf byteBuf2 = this.buffer;
                    if (byteBuf2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.writeHeader(byteBuf2, FastCgiRequestKt.access$getSTDIN$p(), content.readableBytes());
                }
                fastCgiChannel.write((Object)this.buffer);
                this.buffer = null;
                if (content != null) {
                    ByteBuf headerBuffer;
                    fastCgiChannel.write((Object)content);
                    releaseContent = false;
                    ByteBuf byteBuf3 = headerBuffer = fastCgiChannel.alloc().ioBuffer(8, 8);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf3, (String)"headerBuffer");
                    this.writeHeader(byteBuf3, FastCgiRequestKt.access$getSTDIN$p(), 0);
                    fastCgiChannel.write((Object)headerBuffer);
                }
                if (!releaseContent) break block10;
                PreconditionsKt.assert((content != null ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                if (releaseContent) {
                    PreconditionsKt.assert((content != null ? 1 : 0) != 0);
                    ByteBuf byteBuf = content;
                    if (byteBuf == null) {
                        Intrinsics.throwNpe();
                    }
                    byteBuf.release();
                }
                throw throwable;
            }
            ByteBuf byteBuf = content;
            if (byteBuf == null) {
                Intrinsics.throwNpe();
            }
            byteBuf.release();
        }
        fastCgiChannel.flush();
    }

    private final void writeHeader(ByteBuf buffer, int type, int length) {
        buffer.writeByte(FastCgiRequestKt.access$getVERSION$p());
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }

    public final int getRequestId() {
        return this.requestId;
    }

    public FastCgiRequest(int requestId, @NotNull ByteBufAllocator allocator) {
        Intrinsics.checkParameterIsNotNull((Object)allocator, (String)"allocator");
        this.requestId = requestId;
        ByteBuf byteBuf = this.buffer = allocator.ioBuffer(4096);
        if (byteBuf == null) {
            Intrinsics.throwNpe();
        }
        this.writeHeader(byteBuf, FastCgiRequestKt.access$getBEGIN_REQUEST$p(), 8);
        ByteBuf byteBuf2 = this.buffer;
        if (byteBuf2 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf2.writeShort(FastCgiRequestKt.access$getRESPONDER$p());
        ByteBuf byteBuf3 = this.buffer;
        if (byteBuf3 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf3.writeByte(FastCgiRequestKt.access$getFCGI_KEEP_CONNECTION$p());
        ByteBuf byteBuf4 = this.buffer;
        if (byteBuf4 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf4.writeZero(5);
    }
}

