/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiRequest;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0011\u001d)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0005'1\u0001\u0011$\u0001M\u0001C\u001bI1\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015:\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a%Qe\u0004\u0003\u000b\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\u0007!EQ\"\u0001\r\n3\u0019A\u0019\"\u0004\u0003\n\u0005%\t\u0001T\u0003\r\u000bK5!\u0011\u0001C\u0006\u000e\u0003aA\u0011d\u0001E\f\u001b\u0005AB\"\u0007\u0003\t\u001a5\u0011A\u0012\u0001\r\u000eK1AY\"D\u0001\u0019\u0011e\u0019\u0001BD\u0007\u00021\u001bIB\u0001#\b\u000e\u00051\u0005\u0001$D\u0013\f\u0011=i\u0011\u0001\u0007\u0005\u001a\u0007!]Q\"\u0001\r\r3\rAI\"D\u0001\u0019\u001b%:A!\u0011\u0005\t\u00065\t\u0001dA)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003C\u0011!\u001dQ\u0002B\u0005\u0003\u0013\u0005AJ\u0001\u0007\u0003R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000b!-\u0001"}, strings={"Lorg/jetbrains/io/fastCgi/FastCgiService;", "Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "requestIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "requests", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lio/netty/channel/Channel;", "getRequests", "()Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "allocateRequestId", "", "channel", "configureBootstrap", "", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "handleError", "fastCgiRequest", "Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "content", "Lio/netty/buffer/ByteBuf;", "responseReceived", "id", "buffer", "send"}, moduleName="built-in-server")
public abstract class FastCgiService
extends SingleConnectionNetService {
    private final AtomicInteger requestIdCounter;
    @NotNull
    private final ConcurrentIntObjectMap<Channel> requests;

    @NotNull
    protected final ConcurrentIntObjectMap<Channel> getRequests() {
        return this.requests;
    }

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap $receiver = bootstrap;
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(this, errorOutputConsumer){
            final /* synthetic */ FastCgiService this$0;
            final /* synthetic */ Consumer $errorOutputConsumer$inlined;

            protected void initChannel(Channel channel) {
                Channel it = channel;
                it.pipeline().addLast("fastCgiDecoder", (ChannelHandler)new FastCgiDecoder((Consumer<String>)this.$errorOutputConsumer$inlined, this.this$0));
                it.pipeline().addLast("exceptionHandler", ChannelExceptionHandler.getInstance());
                ChannelFuture $receiver = it.closeFuture();
                $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this.this$0, this.$errorOutputConsumer$inlined){
                    final /* synthetic */ FastCgiService this$0;
                    final /* synthetic */ Consumer $errorOutputConsumer$inlined;

                    public void operationComplete(ChannelFuture future2) {
                        ChannelFuture it = future2;
                        FastCgiService.access$getRequestIdCounter$p(this.this$0).set(0);
                        if (!this.this$0.getRequests().isEmpty()) {
                            List waitingClients = CollectionsKt.toList((Enumeration)this.this$0.getRequests().elements());
                            this.this$0.getRequests().clear();
                            Iterator<E> iterator = waitingClients.iterator();
                            while (iterator.hasNext()) {
                                Channel channel;
                                Channel channel2 = channel = (Channel)iterator.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
                                FastCgiServiceKt.access$sendBadGateway(channel2);
                            }
                        }
                    }
                    {
                        this.this$0 = fastCgiService;
                        this.$errorOutputConsumer$inlined = consumer;
                    }
                });
            }
            {
                this.this$0 = fastCgiService;
                this.$errorOutputConsumer$inlined = consumer;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void send(@NotNull FastCgiRequest fastCgiRequest, @NotNull ByteBuf content) {
        ByteBuf notEmptyContent;
        Intrinsics.checkParameterIsNotNull((Object)fastCgiRequest, (String)"fastCgiRequest");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (content.isReadable()) {
            content.retain();
            notEmptyContent = content;
            notEmptyContent.touch();
        } else {
            notEmptyContent = null;
        }
        try {
            Promise<Channel> promise2;
            if (this.getProcessHandler().has()) {
                Channel channel = this.getProcessChannel().get();
                if (channel != null && channel.isOpen()) {
                    fastCgiRequest.writeToServerChannel(notEmptyContent, channel);
                    return;
                }
                promise2 = this.connectAgain();
            } else {
                Promise<Channel> promise3 = this.getProcessHandler().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"processHandler.get()");
                promise2 = promise3;
            }
            promise2.done(new Consumer<T>(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void consume(@Nullable Object it) {
                    Channel channel = FastCgiService.access$getProcessChannel$p(this.this$0).get();
                    if (channel == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$fastCgiRequest.writeToServerChannel(this.$notEmptyContent, channel);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            }).rejected((Consumer)new Consumer<Throwable>(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void consume(Throwable it) {
                    Promise.logError((Logger)FastCgiServiceKt.getLOG(), (Throwable)it);
                    FastCgiService.access$handleError(this.this$0, this.$fastCgiRequest, this.$notEmptyContent);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            });
            return;
        }
        catch (Throwable e) {
            FastCgiServiceKt.getLOG().error(e);
            this.handleError(fastCgiRequest, notEmptyContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleError(FastCgiRequest fastCgiRequest, ByteBuf content) {
        try {
            if (content != null && content.refCnt() != 0) {
                content.release();
            }
        }
        finally {
            Channel channel = (Channel)this.requests.remove(fastCgiRequest.getRequestId());
            if (channel != null) {
                FastCgiServiceKt.access$sendBadGateway(channel);
            }
        }
    }

    public final int allocateRequestId(@NotNull Channel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)channel);
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void responseReceived(int id, @Nullable ByteBuf buffer) {
        Channel channel = (Channel)this.requests.remove(id);
        if (channel == null || !channel.isActive()) {
            ByteBuf byteBuf = buffer;
            Boolean bl = byteBuf != null ? Boolean.valueOf(byteBuf.release()) : null;
            return;
        }
        if (buffer == null) {
            Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
        try {
            FastCgiServiceKt.access$parseHeaders((HttpResponse)httpResponse, buffer);
            Responses.addServer((HttpResponse)httpResponse);
            if (!HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)httpResponse))) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)httpResponse), (long)buffer.readableBytes());
            }
        }
        catch (Throwable e) {
            buffer.release();
            try {
                FastCgiServiceKt.getLOG().error(e);
            }
            finally {
                Responses.sendStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR, channel);
            }
            return;
        }
        channel.writeAndFlush((Object)httpResponse);
    }

    public FastCgiService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.requestIdCounter = new AtomicInteger();
        ConcurrentIntObjectMap concurrentIntObjectMap = ContainerUtil.createConcurrentIntObjectMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentIntObjectMap, (String)"ContainerUtil.createConc\u2026ntIntObjectMap<Channel>()");
        this.requests = concurrentIntObjectMap;
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getRequestIdCounter$p(FastCgiService $this) {
        return $this.requestIdCounter;
    }

    @NotNull
    public static final /* synthetic */ AtomicReference<Channel> access$getProcessChannel$p(FastCgiService $this) {
        return $this.getProcessChannel();
    }

    public static final /* synthetic */ void access$handleError(FastCgiService $this, @NotNull FastCgiRequest fastCgiRequest, @Nullable ByteBuf content) {
        $this.handleError(fastCgiRequest, content);
    }
}

