/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import gnu.trove.THashSet;
import gnu.trove.TObjectProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.ExceptionHandlerImpl;
import org.jetbrains.io.webSocket.WebSocketServerOptions;

public class ClientManager
implements Disposable {
    public static final AttributeKey<Client> CLIENT = AttributeKey.valueOf((String)"SocketHandler.client");
    private final SimpleTimerTask heartbeatTimer;
    @Nullable
    private final ClientListener listener;
    @NotNull
    public final ExceptionHandler exceptionHandler;
    private final THashSet<Client> clients;

    public ClientManager() {
        this(null, new ExceptionHandlerImpl());
    }

    public ClientManager(@Nullable ClientListener listener, @NotNull ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandler", "org/jetbrains/io/jsonRpc/ClientManager", "<init>"));
        }
        this(null, exceptionHandler, listener);
    }

    public ClientManager(@Nullable WebSocketServerOptions options, @NotNull ExceptionHandler exceptionHandler, @Nullable ClientListener listener) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionHandler", "org/jetbrains/io/jsonRpc/ClientManager", "<init>"));
        }
        this.clients = new THashSet();
        this.exceptionHandler = exceptionHandler;
        this.listener = listener;
        this.heartbeatTimer = SimpleTimer.getInstance().setUp(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                THashSet tHashSet = ClientManager.this.clients;
                synchronized (tHashSet) {
                    if (ClientManager.this.clients.isEmpty()) {
                        return;
                    }
                    ClientManager.this.clients.forEach((TObjectProcedure)new TObjectProcedure<Client>(){

                        public boolean execute(Client client) {
                            if (client.channel.isActive()) {
                                client.sendHeartbeat();
                            }
                            return true;
                        }
                    });
                }
            }
        }, (long)(options == null ? new WebSocketServerOptions() : options).heartbeatDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/ClientManager", "addClient"));
        }
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            this.clients.add((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            return this.clients.size();
        }
    }

    public boolean hasClients() {
        return this.getClientCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.heartbeatTimer.cancel();
        }
        finally {
            THashSet<Client> tHashSet = this.clients;
            synchronized (tHashSet) {
                this.clients.clear();
            }
        }
    }

    public <T> void send(final int messageId, final @NotNull ByteBuf message, final @Nullable List<AsyncPromise<Pair<Client, T>>> results) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/jsonRpc/ClientManager", "send"));
        }
        this.forEachClient(new TObjectProcedure<Client>(){
            private boolean first;

            public boolean execute(Client client) {
                try {
                    AsyncPromise result2 = client.send(messageId, this.first ? message : message.duplicate());
                    this.first = false;
                    if (results != null) {
                        results.add(result2);
                    }
                }
                catch (Throwable e) {
                    ClientManager.this.exceptionHandler.exceptionCaught(e);
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnectClient(@NotNull ChannelHandlerContext context, @NotNull Client client, boolean closeChannel) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/jsonRpc/ClientManager", "disconnectClient"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/ClientManager", "disconnectClient"));
        }
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            if (!this.clients.remove((Object)client)) {
                return false;
            }
        }
        try {
            context.attr(CLIENT).remove();
            if (closeChannel) {
                context.channel().close();
            }
            client.rejectAsyncResults(this.exceptionHandler);
        }
        finally {
            if (this.listener != null) {
                this.listener.disconnected(client);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachClient(@NotNull TObjectProcedure<Client> procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "org/jetbrains/io/jsonRpc/ClientManager", "forEachClient"));
        }
        THashSet<Client> tHashSet = this.clients;
        synchronized (tHashSet) {
            if (this.clients.isEmpty()) {
                return;
            }
            this.clients.forEach(procedure);
        }
    }
}

