/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.EditDistance;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.highlighting.AbstractManifestQuickFix;
import org.jetbrains.lang.manifest.psi.Header;

public class MisspelledHeaderInspection
extends LocalInspectionTool {
    private static final int MAX_SUGGESTIONS = 5;
    private static final int MAX_DISTANCE = 4;
    private static final int TYPO_DISTANCE = 2;
    @AbstractCollection(surroundWithTag=false, elementTag="header")
    public final Set<String> CUSTOM_HEADERS = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final HeaderParserRepository myRepository = HeaderParserRepository.getInstance();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof Header) {
                    Header header = (Header)element;
                    String headerName = header.getName();
                    TreeSet<Suggestion> matches = new TreeSet<Suggestion>();
                    this.addMatches(headerName, MisspelledHeaderInspection.this.CUSTOM_HEADERS, matches);
                    this.addMatches(headerName, MisspelledHeaderInspection.this.myRepository.getAllHeaderNames(), matches);
                    Suggestion bestMatch = (Suggestion)ContainerUtil.getFirstItem(matches);
                    if (bestMatch != null && headerName.equals(bestMatch.getWord())) {
                        return;
                    }
                    ArrayList<AbstractManifestQuickFix> fixes = new ArrayList<AbstractManifestQuickFix>();
                    for (Suggestion match : matches) {
                        fixes.add(new HeaderRenameQuickFix(header, match.getWord()));
                        if (fixes.size() != 5) continue;
                        break;
                    }
                    if (bestMatch == null || bestMatch.getMetrics() > 2) {
                        fixes.add(new CustomHeaderQuickFix(header, MisspelledHeaderInspection.this.CUSTOM_HEADERS));
                    }
                    holder.registerProblem((PsiElement)header.getNameElement(), ManifestBundle.message("inspection.header.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(new LocalQuickFix[fixes.size()]));
                }
            }

            private void addMatches(String headerName, Collection<String> headers, SortedSet<Suggestion> matches) {
                for (String candidate : headers) {
                    int distance = EditDistance.optimalAlignment((CharSequence)headerName, (CharSequence)candidate, (boolean)false);
                    if (distance > 4) continue;
                    matches.add(new Suggestion(candidate, distance));
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel(this.CUSTOM_HEADERS);
    }

    private static class CustomHeaderQuickFix
    extends AbstractManifestQuickFix {
        private final String myHeaderName;
        private final Collection<String> myHeaders;

        private CustomHeaderQuickFix(Header header, Collection<String> headers) {
            super((PsiElement)header);
            this.myHeaderName = header.getName();
            this.myHeaders = headers;
        }

        @NotNull
        public String getText() {
            String string = ManifestBundle.message("inspection.header.remember.fix", this.myHeaderName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix", "invoke"));
            }
            this.myHeaders.add(this.myHeaderName);
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
            InspectionProfileManager.getInstance().fireProfileChanged((Profile)profile);
        }
    }

    private static class HeaderRenameQuickFix
    extends AbstractManifestQuickFix {
        private final String myNewName;

        private HeaderRenameQuickFix(Header header, String newName) {
            super((PsiElement)header);
            this.myNewName = newName;
        }

        @NotNull
        public String getText() {
            String string = ManifestBundle.message("inspection.header.rename.fix", this.myNewName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix", "invoke"));
            }
            ((Header)startElement).setName(this.myNewName);
        }
    }

    private static class OptionsPanel
    extends JPanel {
        public OptionsPanel(final Set<String> headers) {
            super(new BorderLayout(5, 5));
            this.add((Component)new JLabel(ManifestBundle.message("inspection.header.ui.label", new Object[0])), "North");
            final JTextArea area = new JTextArea("");
            this.add((Component)area, "Center");
            if (!headers.isEmpty()) {
                area.setText(StringUtil.join(new TreeSet<String>(headers), (String)"\n"));
            }
            area.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    headers.clear();
                    for (String line : StringUtil.split((String)area.getText(), (String)"\n")) {
                        String header = line.trim();
                        if (header.isEmpty()) continue;
                        headers.add(header);
                    }
                }
            });
        }
    }
}

