/*
 * Decompiled with CFR 0.152.
 */
package git4idea.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranchesSearcher;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.util.StringScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GitTreeDiffProvider
implements TreeDiffProvider {
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.diff.GitTreeDiffProvider");
    private final Project myProject;

    public GitTreeDiffProvider(Project project) {
        this.myProject = project;
    }

    public Collection<String> getRemotelyChanged(VirtualFile vcsRoot, Collection<String> paths) {
        try {
            GitBranchesSearcher searcher = new GitBranchesSearcher(this.myProject, vcsRoot, true);
            if (searcher.getLocal() == null || searcher.getRemote() == null) {
                return Collections.emptyList();
            }
            ArrayList<String> rc = new ArrayList<String>();
            ArrayList<FilePath> files = new ArrayList<FilePath>(paths.size());
            for (String path : paths) {
                files.add(VcsUtil.getFilePath((String)path));
            }
            for (List pathList : VcsFileUtil.chunkPaths((VirtualFile)vcsRoot, files)) {
                GitSimpleHandler handler = new GitSimpleHandler(this.myProject, vcsRoot, GitCommand.DIFF);
                handler.addParameters("--name-status", "--diff-filter=ADCRUX", "-M", "HEAD..." + searcher.getRemote().getFullName());
                handler.setSilent(true);
                handler.setStdoutSuppressed(true);
                handler.endOptions();
                handler.addParameters(pathList);
                String output = handler.run();
                Collection<String> pathCollection = GitChangeUtils.parseDiffForPaths(vcsRoot.getPath(), new StringScanner(output));
                rc.addAll(pathCollection);
            }
            return rc;
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return Collections.emptyList();
        }
    }
}

