/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.configuration;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.BaseTableView;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.ListProperty;
import com.intellij.util.config.Storage;
import com.intellij.util.config.StorageProperty;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public abstract class UIPropertyBinding {
    public abstract void loadValues(AbstractProperty.AbstractPropertyContainer var1);

    public abstract void apply(AbstractProperty.AbstractPropertyContainer var1);

    public void beforeClose(AbstractProperty.AbstractPropertyContainer container) {
    }

    public abstract void beDisabled();

    public abstract void beEnabled();

    public abstract void addAllPropertiesTo(Collection<AbstractProperty> var1);

    public static class ComboBoxBinding
    extends ComponentBinding<JComboBox, AbstractProperty<String>> {
        public ComboBoxBinding(JComboBox comboBox, AbstractProperty<String> property) {
            super(comboBox, property);
        }

        @Override
        public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
            ((JComboBox)this.getComponent()).getModel().setSelectedItem(this.getProperty().get(container));
        }

        @Override
        public void apply(AbstractProperty.AbstractPropertyContainer container) {
            this.getProperty().set(container, (Object)((String)((JComboBox)this.getComponent()).getSelectedItem()));
        }
    }

    public static class OrderListBinding<T>
    extends BaseListBinding<T> {
        public OrderListBinding(JList list, ListProperty<T> property) {
            super(property, list);
            list.setModel(new DefaultListModel());
        }

        @Override
        public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
            DefaultListModel model = this.getModel();
            model.clear();
            Iterator iterator = this.getProperty().getIterator(container);
            while (iterator.hasNext()) {
                Object item = iterator.next();
                model.addElement(item);
            }
            ScrollingUtil.ensureSelectionExists((JList)this.getList());
        }

        private DefaultListModel getModel() {
            return (DefaultListModel)this.getList().getModel();
        }

        public void addAddManyFacility(JButton button, final Factory<List<T>> factory) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List items = (List)factory.create();
                    OrderListBinding.this.getList().requestFocusInWindow();
                    if (items == null || items.size() == 0) {
                        return;
                    }
                    for (Object item : items) {
                        OrderListBinding.this.getModel().addElement(item);
                        ScrollingUtil.selectItem((JList)OrderListBinding.this.getList(), item);
                    }
                }
            });
            this.addComponent(button);
        }
    }

    public static class SortedListBinding<T extends JDOMExternalizable>
    extends BaseListBinding<T> {
        public SortedListBinding(JList list, ListProperty<T> property, Comparator<T> comparator) {
            super(property, list);
            list.setModel(new SortedListModel(comparator));
        }

        @Override
        public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
            this.getModel().setAll((Collection)this.getProperty().get(container));
            ScrollingUtil.ensureSelectionExists((JList)this.getList());
        }

        private SortedListModel<T> getModel() {
            return (SortedListModel)this.getList().getModel();
        }
    }

    private static abstract class BaseListBinding<Item>
    extends UIPropertyBinding {
        private final ArrayList<JComponent> myComponents = new ArrayList();
        private final JList myList;
        private final ListProperty<Item> myProperty;

        protected BaseListBinding(ListProperty<Item> property, JList list) {
            this.myList = list;
            this.myProperty = property;
            this.myComponents.add(this.myList);
        }

        @Override
        public void beDisabled() {
            for (JComponent component : this.myComponents) {
                component.setEnabled(false);
            }
        }

        @Override
        public void beEnabled() {
            for (JComponent component : this.myComponents) {
                component.setEnabled(true);
            }
        }

        protected void addComponent(JComponent component) {
            this.myComponents.add(component);
        }

        @Override
        public void apply(AbstractProperty.AbstractPropertyContainer container) {
            ListModel model = this.myList.getModel();
            ArrayList list = new ArrayList();
            for (int i = 0; i < model.getSize(); ++i) {
                list.add(model.getElementAt(i));
            }
            this.myProperty.set(container, list);
        }

        @Override
        public void addAllPropertiesTo(Collection<AbstractProperty> properties) {
            properties.add((AbstractProperty)this.myProperty);
        }

        protected JList getList() {
            return this.myList;
        }

        protected ListProperty<Item> getProperty() {
            return this.myProperty;
        }
    }

    public static class TableListBinding<T>
    extends ComponentBinding<JTable, ListProperty<T>> {
        private final ListProperty<T> myProperty;
        private final ListTableModel<T> myModel;
        private final Collection<JComponent> myComponents = new ArrayList<JComponent>();
        private StorageProperty myColumnWidthProperty;

        public TableListBinding(JTable table, ColumnInfo[] columns, ListProperty<T> property) {
            super(table, property);
            this.myProperty = property;
            this.myComponents.add(table);
            JTableHeader header = table.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumnModel columnModel = table.getColumnModel();
            this.myModel = new ListTableModel(columns);
            this.myModel.setSortable(false);
            table.setModel((TableModel)this.myModel);
            for (int i = 0; i < columns.length; ++i) {
                int wight;
                ColumnInfo column = columns[i];
                TableColumn tableColumn = columnModel.getColumn(i);
                TableCellEditor editor = column.getEditor(null);
                if (editor != null) {
                    tableColumn.setCellEditor(editor);
                }
                if ((wight = column.getWidth(table)) <= 0) continue;
                tableColumn.setMinWidth(wight);
                tableColumn.setMaxWidth(wight);
            }
            table.setSurrendersFocusOnKeystroke(true);
            this.myModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    JTableHeader header = ((JTable)TableListBinding.this.getComponent()).getTableHeader();
                    if (header != null) {
                        header.repaint();
                    }
                }
            });
        }

        @Override
        public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
            if (this.myColumnWidthProperty != null) {
                BaseTableView.restoreWidth((Storage)((Storage)this.myColumnWidthProperty.get(container)), (TableColumnModel)((JTable)this.getComponent()).getColumnModel());
            }
            this.myModel.setItems((List)this.myProperty.getModifiableList(container));
            if (this.myModel.isSortable()) {
                ColumnInfo[] columnInfos = this.myModel.getColumnInfos();
                int sortByColumn = -1;
                for (int idx = 0; idx < columnInfos.length; ++idx) {
                    ColumnInfo columnInfo = columnInfos[idx];
                    if (!columnInfo.isSortable()) continue;
                    sortByColumn = idx;
                    break;
                }
            }
            TableUtil.ensureSelectionExists((JTable)((JTable)this.getComponent()));
        }

        @Override
        public void beDisabled() {
            for (JComponent component : this.myComponents) {
                component.setEnabled(false);
            }
        }

        @Override
        public void beEnabled() {
            for (JComponent component : this.myComponents) {
                component.setEnabled(true);
            }
        }

        @Override
        public void apply(AbstractProperty.AbstractPropertyContainer container) {
            this.myProperty.set(container, (Object)this.myModel.getItems());
        }

        @Override
        public void beforeClose(AbstractProperty.AbstractPropertyContainer container) {
            if (this.myColumnWidthProperty != null) {
                BaseTableView.storeWidth((Storage)((Storage)this.myColumnWidthProperty.get(container)), (TableColumnModel)((JTable)this.getComponent()).getColumnModel());
            }
        }

        public void setColumnWidths(StorageProperty property) {
            this.myColumnWidthProperty = property;
            ((JTable)this.getComponent()).getTableHeader().setResizingAllowed(true);
        }

        public void addAddFacility(JButton addButton, final Factory<T> factory) {
            this.myComponents.add(addButton);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JTable table = (JTable)TableListBinding.this.getComponent();
                    if (table.isEditing() && !table.getCellEditor().stopCellEditing()) {
                        return;
                    }
                    Object item = factory.create();
                    if (item == null) {
                        return;
                    }
                    ArrayList<Object> items = new ArrayList<Object>(TableListBinding.this.myModel.getItems());
                    items.add(item);
                    TableListBinding.this.myModel.setItems(items);
                    int newIndex = TableListBinding.this.myModel.indexOf(item);
                    ListSelectionModel selectionModel = table.getSelectionModel();
                    selectionModel.clearSelection();
                    selectionModel.setSelectionInterval(newIndex, newIndex);
                    ColumnInfo[] columns = TableListBinding.this.myModel.getColumnInfos();
                    for (int i = 0; i < columns.length; ++i) {
                        ColumnInfo column = columns[i];
                        if (!column.isCellEditable(item)) continue;
                        table.requestFocusInWindow();
                        table.editCellAt(newIndex, i);
                        break;
                    }
                }
            });
        }

        public void setSortable(boolean isSortable) {
            this.myModel.setSortable(isSortable);
        }

        public void addRemoveFacility(final JButton button, final Condition<T> removable) {
            this.myComponents.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableUtil.removeSelectedItems((JTable)((JTable)TableListBinding.this.getComponent()));
                }
            });
            ((JTable)this.getComponent()).getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    TableListBinding.this.updateRemoveButton(button, removable);
                }
            });
        }

        public void updateRemoveButton(JButton button, Condition<T> removable) {
            JTable table = (JTable)this.getComponent();
            ListSelectionModel selectionModel = table.getSelectionModel();
            boolean enable = false;
            if (!selectionModel.isSelectionEmpty()) {
                enable = true;
                for (int i : table.getSelectedRows()) {
                    if (removable.value(this.myModel.getItems().get(i))) continue;
                    enable = false;
                    break;
                }
            }
            button.setEnabled(enable);
        }
    }

    private static class IntTextBinding
    extends ComponentBinding<JTextComponent, AbstractProperty<Integer>> {
        public IntTextBinding(JTextComponent textComponent, AbstractProperty<Integer> property) {
            super(textComponent, property);
        }

        @Override
        public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
            ((JTextComponent)this.getComponent()).setText(((Integer)this.getProperty().get(container)).toString());
        }

        @Override
        public void apply(AbstractProperty.AbstractPropertyContainer container) {
            int value;
            try {
                value = Integer.parseInt(((JTextComponent)this.getComponent()).getText());
            }
            catch (NumberFormatException e) {
                return;
            }
            this.getProperty().set(container, (Object)value);
        }
    }

    public static class TextBinding
    extends ComponentBinding<JTextComponent, AbstractProperty<String>> {
        private final ChangeValueSupport myChangeSupport;

        public TextBinding(JTextComponent textComponent, AbstractProperty<String> property) {
            super(textComponent, property);
            this.myChangeSupport = ChangeValueSupport.create(textComponent, ListenerInstaller.TEXT_LISTENER_INSTALLER, property.getName());
        }

        @Override
        public void apply(AbstractProperty.AbstractPropertyContainer container) {
            this.getProperty().set(container, (Object)((JTextComponent)this.getComponent()).getText());
        }

        @Override
        public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
            this.myChangeSupport.stop();
            this.loadValuesImpl(container);
            this.myChangeSupport.start();
        }

        protected void loadValuesImpl(AbstractProperty.AbstractPropertyContainer container) {
            ((JTextComponent)this.getComponent()).setText((String)this.getProperty().get(container));
        }

        public void addChangeListener(PropertyChangeListener listener) {
            this.myChangeSupport.addListener(listener);
        }

        @Override
        public void beforeClose(AbstractProperty.AbstractPropertyContainer container) {
            this.myChangeSupport.stop();
        }
    }

    private static class ChangeValueSupport<Comp extends JComponent, Listener> {
        private final Comp myComponent;
        private final ListenerInstaller<Comp, Listener> myInstaller;
        private final PropertyChangeSupport myChangeSupport;
        private Listener myChangeListener = null;
        private final String myPropertyName;

        public ChangeValueSupport(Comp component, ListenerInstaller<Comp, Listener> installer, String propertyName) {
            this.myComponent = component;
            this.myPropertyName = propertyName;
            this.myChangeSupport = new PropertyChangeSupport(this.myPropertyName);
            this.myInstaller = installer;
        }

        public static <Comp extends JComponent, Listener> ChangeValueSupport create(Comp component, ListenerInstaller<Comp, Listener> installer, String propertyName) {
            return new ChangeValueSupport<Comp, Listener>(component, installer, propertyName);
        }

        public void stop() {
            if (this.myChangeListener != null) {
                this.myInstaller.removeListener(this.myComponent, this.myChangeListener);
            }
        }

        public void start() {
            if (this.myChangeListener != null) {
                this.myInstaller.setListener(this.myComponent, this.myChangeListener);
            }
        }

        public void addListener(PropertyChangeListener listener) {
            this.myChangeSupport.addPropertyChangeListener(listener);
            if (this.myChangeListener != null) {
                return;
            }
            this.myChangeListener = this.myInstaller.create(this.myChangeSupport, this.myPropertyName);
            this.myInstaller.setListener(this.myComponent, this.myChangeListener);
        }
    }

    private static abstract class ListenerInstaller<Comp extends JComponent, Listener> {
        public static final ListenerInstaller<JToggleButton, ItemListener> TOGGLE_BUTTON = new ListenerInstaller<JToggleButton, ItemListener>(){

            @Override
            public ItemListener create(final PropertyChangeSupport changeSupport, final String propertyName) {
                return new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        changeSupport.firePropertyChange(propertyName, null, null);
                    }
                };
            }

            @Override
            public void setListener(JToggleButton component, ItemListener listener) {
                component.getModel().addItemListener(listener);
            }

            @Override
            public void removeListener(JToggleButton component, ItemListener listener) {
                component.getModel().removeItemListener(listener);
            }
        };
        public static final ListenerInstaller<JTextComponent, DocumentListener> TEXT_LISTENER_INSTALLER = new ListenerInstaller<JTextComponent, DocumentListener>(){

            @Override
            public DocumentListener create(final PropertyChangeSupport changeSupport, final String propertyName) {
                return new DocumentAdapter(){

                    protected void textChanged(DocumentEvent e) {
                        changeSupport.firePropertyChange(propertyName, null, null);
                    }
                };
            }

            @Override
            public void setListener(JTextComponent textComponent, DocumentListener documentListener) {
                textComponent.getDocument().addDocumentListener(documentListener);
            }

            @Override
            public void removeListener(JTextComponent textComponent, DocumentListener documentListener) {
                textComponent.getDocument().removeDocumentListener(documentListener);
            }
        };

        private ListenerInstaller() {
        }

        public abstract Listener create(PropertyChangeSupport var1, String var2);

        public abstract void setListener(Comp var1, Listener var2);

        public abstract void removeListener(Comp var1, Listener var2);
    }

    public static class ToggleButtonBinding
    extends ComponentBinding<JToggleButton, AbstractProperty<Boolean>> {
        private final ChangeValueSupport myChangeSupport;

        public ToggleButtonBinding(JToggleButton toggleButton, AbstractProperty<Boolean> property) {
            super(toggleButton, property);
            this.myChangeSupport = ChangeValueSupport.create(toggleButton, ListenerInstaller.TOGGLE_BUTTON, property.getName());
        }

        @Override
        public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
            this.myChangeSupport.stop();
            ((JToggleButton)this.getComponent()).setSelected((Boolean)this.getProperty().get(container));
            this.myChangeSupport.start();
        }

        @Override
        public void apply(AbstractProperty.AbstractPropertyContainer container) {
            this.getProperty().set(container, (Object)((JToggleButton)this.getComponent()).isSelected());
        }

        public void addChangeListener(PropertyChangeListener listener) {
            this.myChangeSupport.addListener(listener);
        }

        @Override
        public void beforeClose(AbstractProperty.AbstractPropertyContainer container) {
            this.myChangeSupport.stop();
        }
    }

    private static abstract class ComponentBinding<Comp extends JComponent, Prop extends AbstractProperty>
    extends UIPropertyBinding {
        private final Comp myComponent;
        private final Prop myProperty;

        protected ComponentBinding(Comp component, Prop property) {
            this.myComponent = component;
            this.myProperty = property;
        }

        @Override
        public void beDisabled() {
            ((JComponent)this.myComponent).setEnabled(false);
        }

        @Override
        public void beEnabled() {
            ((JComponent)this.myComponent).setEnabled(true);
        }

        @Override
        public void addAllPropertiesTo(Collection<AbstractProperty> properties) {
            properties.add((AbstractProperty)this.myProperty);
        }

        protected Comp getComponent() {
            return this.myComponent;
        }

        protected Prop getProperty() {
            return this.myProperty;
        }
    }

    public static class Composite
    extends UIPropertyBinding {
        private final ArrayList<UIPropertyBinding> myBindings = new ArrayList();

        public ToggleButtonBinding bindBoolean(JToggleButton toggleButton, AbstractProperty<Boolean> property) {
            ToggleButtonBinding binding = new ToggleButtonBinding(toggleButton, property);
            this.myBindings.add(binding);
            return binding;
        }

        public void bindInt(JTextComponent textComponent, AbstractProperty<Integer> property) {
            this.myBindings.add(new IntTextBinding(textComponent, property));
        }

        public TextBinding bindString(JTextComponent textComponent, AbstractProperty<String> property) {
            TextBinding textBinding = new TextBinding(textComponent, property);
            this.myBindings.add(textBinding);
            return textBinding;
        }

        @Override
        public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
            for (UIPropertyBinding binding : this.myBindings) {
                binding.loadValues(container);
            }
        }

        @Override
        public void apply(AbstractProperty.AbstractPropertyContainer container) {
            for (UIPropertyBinding propertyBinding : this.myBindings) {
                propertyBinding.apply(container);
            }
        }

        @Override
        public void beforeClose(AbstractProperty.AbstractPropertyContainer container) {
            for (UIPropertyBinding binding : this.myBindings) {
                binding.beforeClose(container);
            }
        }

        public void bindString(JComboBox comboBox, AbstractProperty<String> property) {
            this.myBindings.add(new ComboBoxBinding(comboBox, property));
        }

        public <T extends JDOMExternalizable> TableListBinding<T> bindList(JTable table, ColumnInfo[] columns, ListProperty<T> property) {
            TableListBinding<T> binding = new TableListBinding<T>(table, columns, property);
            this.myBindings.add(binding);
            return binding;
        }

        public void addBinding(UIPropertyBinding binding) {
            this.myBindings.add(binding);
        }

        @Override
        public void beDisabled() {
            for (UIPropertyBinding binding : this.myBindings) {
                binding.beDisabled();
            }
        }

        @Override
        public void beEnabled() {
            for (UIPropertyBinding binding : this.myBindings) {
                binding.beEnabled();
            }
        }

        @Override
        public void addAllPropertiesTo(Collection<AbstractProperty> properties) {
            for (UIPropertyBinding binding : this.myBindings) {
                binding.addAllPropertiesTo(properties);
            }
        }

        public <T> OrderListBinding<T> bindList(JList list, ListProperty<T> property) {
            OrderListBinding<T> binding = new OrderListBinding<T>(list, property);
            this.addBinding(binding);
            return binding;
        }

        public void bindString(JLabel label, AbstractProperty<String> property) {
            this.addBinding(new ComponentBinding<JLabel, AbstractProperty<String>>(label, property){

                @Override
                public void loadValues(AbstractProperty.AbstractPropertyContainer container) {
                    ((JLabel)this.getComponent()).setText((String)this.getProperty().get(container));
                }

                @Override
                public void apply(AbstractProperty.AbstractPropertyContainer container) {
                }
            });
        }
    }
}

