/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.ide.palette.impl.PaletteToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToolWindowManager
extends LightToolWindowManager {
    public AbstractToolWindowManager(Project project, FileEditorManager fileEditorManager) {
        super(project, fileEditorManager);
    }

    public void projectOpened() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            super.projectOpened();
        }
    }

    @Nullable
    protected DesignerEditorPanelFacade getDesigner(FileEditor editor) {
        if (editor instanceof UIFormEditor) {
            UIFormEditor formEditor = (UIFormEditor)editor;
            return formEditor.getEditor();
        }
        return null;
    }

    protected ToggleEditorModeAction createToggleAction(ToolWindowAnchor anchor) {
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                DesignerToolWindowManager designerManager = DesignerToolWindowManager.getInstance(this.myProject);
                PaletteToolWindowManager paletteManager = PaletteToolWindowManager.getInstance(this.myProject);
                return this.myManager == designerManager ? paletteManager : designerManager;
            }
        };
    }
}

