/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.util;

import com.btr.proxy.selector.fixed.FixedProxySelector;
import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.selector.pac.UrlPacScriptSource;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyUtil {
    public static final int DEFAULT_PROXY_PORT = 80;
    private static List<Proxy> noProxyList;
    private static Pattern pattern;

    public static FixedProxySelector parseProxySettings(String proxyVar) {
        if (proxyVar == null || proxyVar.trim().length() == 0) {
            return null;
        }
        Matcher matcher = pattern.matcher(proxyVar);
        if (matcher.matches()) {
            String host = matcher.group(1);
            int port = !"".equals(matcher.group(2)) ? Integer.parseInt(matcher.group(2)) : 80;
            return new FixedProxySelector(host.trim(), port);
        }
        return null;
    }

    public static synchronized List<Proxy> noProxyList() {
        if (noProxyList == null) {
            ArrayList<Proxy> list = new ArrayList<Proxy>(1);
            list.add(Proxy.NO_PROXY);
            noProxyList = Collections.unmodifiableList(list);
        }
        return noProxyList;
    }

    public static PacProxySelector buildPacSelectorForUrl(String url) {
        PacProxySelector result = null;
        UrlPacScriptSource pacSource = new UrlPacScriptSource(url);
        if (pacSource.isScriptValid()) {
            result = new PacProxySelector(pacSource);
        }
        return result;
    }

    static {
        pattern = Pattern.compile("\\w*?:?/*([^:/]+):?(\\d*)/?");
    }
}

