/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import com.google.common.collect.ImmutableSortedMap;
import java.lang.ref.WeakReference;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelStructSchema<T>
extends ModelSchema<T> {
    private final WeakReference<Class<? extends T>> managedImpl;
    private final ImmutableSortedMap<String, ModelProperty<?>> properties;

    public ModelStructSchema(ModelType<T> type, Iterable<ModelProperty<?>> properties, Class<? extends T> managedImpl) {
        super(type, ModelSchema.Kind.STRUCT);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (ModelProperty<?> property : properties) {
            builder.put((Object)property.getName(), property);
        }
        this.properties = builder.build();
        this.managedImpl = new WeakReference<Class<Class<? extends T>>>(managedImpl);
    }

    public ImmutableSortedMap<String, ModelProperty<?>> getProperties() {
        return this.properties;
    }

    public Class<? extends T> getManagedImpl() {
        return (Class)this.managedImpl.get();
    }
}

