/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenResumeAction;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerParametersSettingEditor;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.MavenRunnerSettingsEditor;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenConsoleImpl;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsEditor;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenRunConfiguration
extends LocatableConfigurationBase
implements ModuleRunProfile {
    private MavenSettings mySettings;

    protected MavenRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
        this.mySettings = new MavenSettings(project);
    }

    public MavenRunConfiguration clone() {
        MavenRunConfiguration clone = (MavenRunConfiguration)super.clone();
        clone.mySettings = this.mySettings.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(RunnerBundle.message("maven.runner.parameters.title", new Object[0]), (SettingsEditor)new MavenRunnerParametersSettingEditor(this.getProject()));
        group.addEditor(ProjectBundle.message("maven.tab.general", new Object[0]), (SettingsEditor)new MavenGeneralSettingsEditor(this.getProject()));
        group.addEditor(RunnerBundle.message("maven.tab.runner", new Object[0]), (SettingsEditor)new MavenRunnerSettingsEditor(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public JavaParameters createJavaParameters(@Nullable Project project) throws ExecutionException {
        return MavenExternalParameters.createJavaParameters(project, this.mySettings.myRunnerParameters, this.mySettings.myGeneralSettings, this.mySettings.myRunnerSettings, this);
    }

    public RunProfileState getState(@NotNull Executor executor, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/maven/execution/MavenRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/idea/maven/execution/MavenRunConfiguration", "getState"));
        }
        JavaCommandLineState state = new JavaCommandLineState(env){

            protected JavaParameters createJavaParameters() throws ExecutionException {
                return MavenRunConfiguration.this.createJavaParameters(env.getProject());
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/maven/execution/MavenRunConfiguration$1", "execute"));
                }
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/idea/maven/execution/MavenRunConfiguration$1", "execute"));
                }
                DefaultExecutionResult res = (DefaultExecutionResult)super.execute(executor, runner);
                if (executor.getId().equals(ToolWindowId.RUN) && MavenResumeAction.isApplicable(env.getProject(), this.getJavaParameters(), MavenRunConfiguration.this)) {
                    MavenResumeAction resumeAction = new MavenResumeAction(res.getProcessHandler(), runner, env);
                    res.setRestartActions(new AnAction[]{resumeAction});
                }
                DefaultExecutionResult defaultExecutionResult = res;
                if (defaultExecutionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunConfiguration$1", "execute"));
                }
                return defaultExecutionResult;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler result = super.startProcess();
                result.setShouldDestroyProcessRecursively(true);
                result.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(ProcessEvent event) {
                        MavenRunConfiguration.this.updateProjectsFolders();
                    }
                });
                OSProcessHandler oSProcessHandler = result;
                if (oSProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunConfiguration$1", "startProcess"));
                }
                return oSProcessHandler;
            }
        };
        state.setConsoleBuilder(MavenConsoleImpl.createConsoleBuilder(this.getProject()));
        return state;
    }

    private void updateProjectsFolders() {
        MavenProjectsManager.getInstance(this.getProject()).updateProjectTargetFolders();
    }

    @NotNull
    public Module[] getModules() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunConfiguration", "getModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    @Nullable
    public MavenGeneralSettings getGeneralSettings() {
        return this.mySettings.myGeneralSettings;
    }

    public void setGeneralSettings(@Nullable MavenGeneralSettings settings) {
        this.mySettings.myGeneralSettings = settings;
    }

    @Nullable
    public MavenRunnerSettings getRunnerSettings() {
        return this.mySettings.myRunnerSettings;
    }

    public void setRunnerSettings(@Nullable MavenRunnerSettings settings) {
        this.mySettings.myRunnerSettings = settings;
    }

    public MavenRunnerParameters getRunnerParameters() {
        return this.mySettings.myRunnerParameters;
    }

    public void setRunnerParameters(MavenRunnerParameters p) {
        this.mySettings.myRunnerParameters = p;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        Element mavenSettingsElement = element.getChild("MavenSettings");
        if (mavenSettingsElement != null) {
            this.mySettings = (MavenSettings)XmlSerializer.deserialize((Element)mavenSettingsElement, MavenSettings.class);
            if (this.mySettings == null) {
                this.mySettings = new MavenSettings();
            }
            if (this.mySettings.myRunnerParameters == null) {
                this.mySettings.myRunnerParameters = new MavenRunnerParameters();
            }
            this.mySettings.myRunnerParameters.fixAfterLoadingFromOldFormat();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings));
    }

    public String suggestedName() {
        return MavenRunConfigurationType.generateName(this.getProject(), this.mySettings.myRunnerParameters);
    }

    public static class MavenSettings
    implements Cloneable {
        public static final String TAG = "MavenSettings";
        public MavenGeneralSettings myGeneralSettings;
        public MavenRunnerSettings myRunnerSettings;
        public MavenRunnerParameters myRunnerParameters;

        public MavenSettings() {
        }

        public MavenSettings(Project project) {
            this(null, null, new MavenRunnerParameters());
        }

        private MavenSettings(@Nullable MavenGeneralSettings cs, @Nullable MavenRunnerSettings rs, MavenRunnerParameters rp) {
            this.myGeneralSettings = cs == null ? null : cs.clone();
            this.myRunnerSettings = rs == null ? null : rs.clone();
            this.myRunnerParameters = rp.clone();
        }

        protected MavenSettings clone() {
            return new MavenSettings(this.myGeneralSettings, this.myRunnerSettings, this.myRunnerParameters);
        }
    }
}

