/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin.reflect.jvm.internal.impl.load.java.structure

import kotlin.reflect.jvm.internal.impl.name.Name

public interface JavaAnnotationArgument {
    public val name: Name?
}

public interface JavaLiteralAnnotationArgument : JavaAnnotationArgument {
    public val value: Any?
}

public interface JavaArrayAnnotationArgument : JavaAnnotationArgument {
    public fun getElements(): List<JavaAnnotationArgument>
}

public interface JavaEnumValueAnnotationArgument : JavaAnnotationArgument {
    public fun resolve(): JavaField?
}

public interface JavaClassObjectAnnotationArgument : JavaAnnotationArgument {
    public fun getReferencedType(): JavaType
}

public interface JavaAnnotationAsAnnotationArgument : JavaAnnotationArgument {
    public fun getAnnotation(): JavaAnnotation
}
