/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;

public class XmlArgusReader
extends XmlReader {
    private static String[] keepCharsList = new String[]{"name", "x", "y", "z", "formalchg", "atomkey", "atsym", "e00", "e01", "e02", "e03", "e10", "e11", "e12", "e13", "e20", "e21", "e22", "e23", "e30", "e31", "e32", "e33"};
    private String atomName1;
    private String atomName2;
    private int bondOrder;
    private int elementContext;
    private static final int UNSET = 0;
    private static final int MOLECULE = 1;
    private static final int ATOM = 2;
    private static final int BOND = 3;
    private static final int TRANSFORMMAT = 4;
    private float[] trans;
    private int ptTrans;

    @Override
    protected String[] getDOMAttributes() {
        return new String[]{"order"};
    }

    @Override
    public void processStartElement(String string) {
        int n = keepCharsList.length;
        while (--n >= 0) {
            if (!keepCharsList[n].equals(string)) continue;
            this.setKeepChars(true);
            break;
        }
        if ("molecule".equals(string)) {
            this.asc.newAtomSet();
            return;
        }
        if ("atom".equals(string)) {
            this.elementContext = 2;
            this.atom = new Atom();
            return;
        }
        if ("bond".equals(string)) {
            this.elementContext = 3;
            this.atomName1 = null;
            this.atomName2 = null;
            this.bondOrder = this.parseBondToken((String)this.atts.get("order"));
            return;
        }
        if ("transformmat".equals(string)) {
            this.elementContext = 4;
            this.trans = new float[16];
            return;
        }
    }

    private int parseBondToken(String string) {
        float f = this.parseFloatStr(string);
        if (Float.isNaN(f) && string.length() >= 1) {
            string = string.toUpperCase();
            switch (string.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 515;
                }
            }
            return this.parseIntStr(string);
        }
        if ((double)f == 1.5) {
            return 515;
        }
        if (f == 2.0f) {
            return 2;
        }
        if (f == 3.0f) {
            return 3;
        }
        return 1;
    }

    @Override
    void processEndElement(String string) {
        if (this.chars != null && this.chars.length() > 0 && this.chars.charAt(this.chars.length() - 1) == '\n') {
            this.chars = this.chars.substring(0, this.chars.length() - 1);
        }
        if ("molecule".equals(string)) {
            this.elementContext = 0;
            return;
        }
        if ("atom".equals(string)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.parent.setAtomCoord(this.atom);
                this.asc.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            this.elementContext = 0;
            return;
        }
        if ("bond".equals(string)) {
            if (this.atomName2 != null) {
                this.asc.addNewBondFromNames(this.atomName1, this.atomName2, this.bondOrder);
            }
            this.elementContext = 0;
            return;
        }
        if ("transformmat".equals(string)) {
            this.elementContext = 0;
            this.parent.setTransform(this.trans[0], this.trans[1], this.trans[2], this.trans[4], this.trans[5], this.trans[6], this.trans[8], this.trans[9], this.trans[10]);
            return;
        }
        if (this.elementContext == 1) {
            if ("name".equals(string)) {
                this.asc.setAtomSetName(this.chars);
                this.setKeepChars(false);
            }
            return;
        }
        if (this.atom != null && this.elementContext == 2) {
            if ("x".equals(string)) {
                this.atom.x = this.parseFloatStr(this.chars);
            } else {
                if ("y".equals(string)) {
                    this.atom.y = this.parseFloatStr(this.chars);
                    return;
                }
                if ("z".equals(string)) {
                    this.atom.z = this.parseFloatStr(this.chars);
                    return;
                }
                if ("atsym".equals(string)) {
                    this.atom.elementSymbol = this.chars;
                    return;
                }
                if ("formalchg".equals(string)) {
                    this.atom.formalCharge = this.parseIntStr(this.chars);
                } else if ("atomkey".equals(string)) {
                    this.atom.atomName = this.chars;
                }
            }
            this.setKeepChars(false);
            return;
        }
        if (this.elementContext == 3) {
            if ("atomkey".equals(string)) {
                if (this.atomName1 == null) {
                    this.atomName1 = this.chars;
                } else {
                    this.atomName2 = this.chars;
                }
                this.setKeepChars(false);
            }
            return;
        }
        if (this.elementContext == 4) {
            this.trans[this.ptTrans++] = this.parseFloatStr(this.chars);
            this.setKeepChars(false);
            return;
        }
    }
}

