/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;

class UFFOOPCalc
extends Calculation {
    UFFOOPCalc() {
    }

    @Override
    void setData(Lst<Object[]> lst, int n, int n2, double d) {
        this.b = this.calcs.minAtoms[n];
        int[] nArray = this.b.getBondedAtomIndexes();
        this.ia = nArray[0];
        this.a = this.calcs.minAtoms[this.ia];
        this.ic = nArray[1];
        this.c = this.calcs.minAtoms[this.ic];
        this.id = nArray[2];
        this.d = this.calcs.minAtoms[this.id];
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = 0.0;
        double d5 = 25.1208;
        switch (n2) {
            case 6: {
                if ((this.b.sType != "C_2" || this.b.hCount <= 1) && this.b.sType != "C_2+" && this.a.sType != "O_2" && this.c.sType != "O_2" && this.d.sType != "O_2") break;
                d5 += 184.2192;
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            default: {
                d5 = 92.1096;
                double d6 = Math.PI / 180;
                switch (n2) {
                    case 15: {
                        d6 *= 84.4339;
                        break;
                    }
                    case 33: {
                        d6 *= 86.9735;
                        break;
                    }
                    case 51: {
                        d6 *= 87.7047;
                        break;
                    }
                    case 83: {
                        d6 *= 90.0;
                    }
                }
                double d7 = Math.cos(d6);
                d2 = d7 * d7;
                d3 = -2.0 * d7;
                d4 = 1.0;
            }
        }
        lst.addLast((Object)new Object[]{new int[]{this.ia, n, this.ic, this.id}, new double[]{d5 /= 3.0, d2, d3, d4, d5 * 10.0}});
        lst.addLast((Object)new Object[]{new int[]{this.ic, n, this.id, this.ia}, new double[]{d5, d2, d3, d4, d5 * 10.0}});
        lst.addLast((Object)new Object[]{new int[]{this.id, n, this.ia, this.ic}, new double[]{d5, d2, d3, d4, d5 * 10.0}});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        double d = this.calcs.isPreliminary ? this.dData[4] : this.dData[0];
        double d2 = this.dData[1];
        double d3 = this.dData[2];
        double d4 = this.dData[3];
        this.calcs.setOopVariables(this, true);
        double d5 = Math.cos(this.theta);
        this.energy = d * (d2 + d3 * d5 + d4 * d5 * d5);
        if (this.calcs.gradients) {
            this.dE = d * (d3 * Math.sin(this.theta) + d4 * 2.0 * Math.sin(this.theta) * d5);
            this.calcs.addForces(this, 4);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(4, this));
        }
        return this.energy;
    }
}

