/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk;

import java.io.File;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDiskCacheAttributes
extends AbstractAuxiliaryCacheAttributes
implements IDiskCacheAttributes {
    private static final long serialVersionUID = 8306631920391711229L;
    private static final Log log = LogFactory.getLog(AbstractDiskCacheAttributes.class);
    private File diskPath;
    private boolean allowRemoveAll = true;
    private int maxPurgatorySize = 5000;
    private static final int DEFAULT_shutdownSpoolTimeLimit = 60;
    private int shutdownSpoolTimeLimit = 60;
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
    private int chunkSize;

    @Override
    public void setDiskPath(String string) {
        this.setDiskPath(new File(string));
    }

    public void setDiskPath(File file) {
        this.diskPath = file;
        boolean bl = this.diskPath.isDirectory();
        if (!bl) {
            bl = this.diskPath.mkdirs();
        }
        if (!bl) {
            log.error("Failed to create directory " + file);
        }
    }

    @Override
    public File getDiskPath() {
        return this.diskPath;
    }

    @Override
    public int getMaxPurgatorySize() {
        return this.maxPurgatorySize;
    }

    @Override
    public void setMaxPurgatorySize(int n) {
        this.maxPurgatorySize = n;
    }

    @Override
    public int getShutdownSpoolTimeLimit() {
        return this.shutdownSpoolTimeLimit;
    }

    @Override
    public void setShutdownSpoolTimeLimit(int n) {
        this.shutdownSpoolTimeLimit = n;
    }

    @Override
    public AuxiliaryCacheAttributes copy() {
        try {
            return (AuxiliaryCacheAttributes)this.clone();
        }
        catch (Exception exception) {
            return this;
        }
    }

    @Override
    public void setAllowRemoveAll(boolean bl) {
        this.allowRemoveAll = bl;
    }

    @Override
    public boolean isAllowRemoveAll() {
        return this.allowRemoveAll;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AbstractDiskCacheAttributes ");
        stringBuilder.append("\n diskPath = " + this.getDiskPath());
        stringBuilder.append("\n maxPurgatorySize   = " + this.getMaxPurgatorySize());
        stringBuilder.append("\n allowRemoveAll   = " + this.isAllowRemoveAll());
        stringBuilder.append("\n ShutdownSpoolTimeLimit   = " + this.getShutdownSpoolTimeLimit());
        return stringBuilder.toString();
    }

    @Override
    public void setDiskLimitType(IDiskCacheAttributes.DiskLimitType diskLimitType) {
        this.diskLimitType = diskLimitType;
    }

    @Override
    public void setDiskLimitTypeName(String string) {
        if (string != null) {
            String string2 = string.trim();
            if ("COUNT".equals(string2)) {
                this.diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
            } else if ("SIZE".equals(string2)) {
                this.diskLimitType = IDiskCacheAttributes.DiskLimitType.SIZE;
            }
        }
    }

    @Override
    public IDiskCacheAttributes.DiskLimitType getDiskLimitType() {
        return this.diskLimitType;
    }
}

