/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.tools.I18n;

public class ExpertToggleAction
extends ToggleAction {
    private static final List<WeakReference<ExpertModeChangeListener>> listeners = new ArrayList<WeakReference<ExpertModeChangeListener>>();
    private static final List<WeakReference<Component>> visibilityToggleListeners = new ArrayList<WeakReference<Component>>();
    private static final ExpertToggleAction INSTANCE = new ExpertToggleAction();

    private static synchronized void fireExpertModeChanged(boolean bl) {
        Object object;
        WeakReference<ExpertModeChangeListener> weakReference;
        Iterator<WeakReference<ExpertModeChangeListener>> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            weakReference = iterator.next();
            object = (ExpertModeChangeListener)weakReference.get();
            if (object == null) {
                iterator.remove();
                continue;
            }
            object.expertChanged(bl);
        }
        weakReference = visibilityToggleListeners.iterator();
        while (weakReference.hasNext()) {
            object = (WeakReference)weakReference.next();
            Component component = (Component)((Reference)object).get();
            if (component == null) {
                weakReference.remove();
                continue;
            }
            component.setVisible(bl);
        }
    }

    public static void addExpertModeChangeListener(ExpertModeChangeListener expertModeChangeListener) {
        ExpertToggleAction.addExpertModeChangeListener(expertModeChangeListener, false);
    }

    public static synchronized void addExpertModeChangeListener(ExpertModeChangeListener expertModeChangeListener, boolean bl) {
        if (expertModeChangeListener == null) {
            return;
        }
        for (WeakReference<ExpertModeChangeListener> weakReference : listeners) {
            if (weakReference.get() != expertModeChangeListener) continue;
            return;
        }
        listeners.add(new WeakReference<ExpertModeChangeListener>(expertModeChangeListener));
        if (bl) {
            expertModeChangeListener.expertChanged(ExpertToggleAction.isExpert());
        }
    }

    public static synchronized void removeExpertModeChangeListener(ExpertModeChangeListener expertModeChangeListener) {
        if (expertModeChangeListener == null) {
            return;
        }
        Iterator<WeakReference<ExpertModeChangeListener>> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<ExpertModeChangeListener> weakReference = iterator.next();
            if (weakReference.get() != null && weakReference.get() != expertModeChangeListener) continue;
            iterator.remove();
        }
    }

    public static synchronized void addVisibilitySwitcher(Component component) {
        if (component == null) {
            return;
        }
        for (WeakReference<Component> weakReference : visibilityToggleListeners) {
            if (weakReference.get() != component) continue;
            return;
        }
        visibilityToggleListeners.add(new WeakReference<Component>(component));
        component.setVisible(ExpertToggleAction.isExpert());
    }

    public static synchronized void removeVisibilitySwitcher(Component component) {
        if (component == null) {
            return;
        }
        Iterator<WeakReference<Component>> iterator = visibilityToggleListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<Component> weakReference = iterator.next();
            if (weakReference.get() != null && weakReference.get() != component) continue;
            iterator.remove();
        }
    }

    public ExpertToggleAction() {
        super(I18n.tr("Expert Mode", new Object[0]), "expert", I18n.tr("Enable/disable expert mode", new Object[0]), null, false);
        this.putValue("toolbar", "expertmode");
        Main.toolbar.register(this);
        this.setSelected(Main.pref.getBoolean("expert", false));
        this.notifySelectedState();
    }

    @Override
    protected final void notifySelectedState() {
        super.notifySelectedState();
        ExpertToggleAction.fireExpertModeChanged(this.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState(actionEvent);
        Main.pref.put("expert", this.isSelected());
        this.notifySelectedState();
    }

    public static ExpertToggleAction getInstance() {
        return INSTANCE;
    }

    public static boolean isExpert() {
        return INSTANCE.isSelected();
    }

    public static interface ExpertModeChangeListener {
        public void expertChanged(boolean var1);
    }
}

