/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Collections;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class AudioMarker
extends ButtonMarker {
    private URL audioUrl;
    private static volatile AudioMarker recentlyPlayedMarker;
    public double syncOffset;
    public boolean timeFromAudio;

    public AudioMarker(LatLon latLon, TemplateEngineDataProvider templateEngineDataProvider, URL uRL, MarkerLayer markerLayer, double d, double d2) {
        super(latLon, templateEngineDataProvider, "speech", markerLayer, d, d2);
        this.audioUrl = uRL;
        this.syncOffset = 0.0;
        this.timeFromAudio = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.play();
    }

    public static AudioMarker recentlyPlayedMarker() {
        return recentlyPlayedMarker;
    }

    public URL url() {
        return this.audioUrl;
    }

    public void play(double d) {
        try {
            Main.map.mapView.playHeadMarker.animate();
            AudioPlayer.play(this.audioUrl, this.offset + this.syncOffset + d);
            recentlyPlayedMarker = this;
        }
        catch (Exception exception) {
            AudioPlayer.audioMalfunction(exception);
        }
    }

    public void play() {
        this.play(0.0);
    }

    public void adjustOffset(double d) {
        this.syncOffset = d;
    }

    public double syncOffset() {
        return this.syncOffset;
    }

    @Override
    protected Marker.TemplateEntryProperty getTextTemplate() {
        return Marker.TemplateEntryProperty.forAudioMarker(this.parentLayer.getName());
    }

    @Override
    public WayPoint convertToWayPoint() {
        WayPoint wayPoint = super.convertToWayPoint();
        GpxLink gpxLink = new GpxLink(this.audioUrl.toString());
        gpxLink.type = "audio";
        wayPoint.put("meta.links", Collections.singleton(gpxLink));
        wayPoint.addExtension("offset", Double.toString(this.offset));
        wayPoint.addExtension("sync-offset", Double.toString(this.syncOffset));
        return wayPoint;
    }
}

