/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.EnumMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.CredentialsManager;

public final class DefaultAuthenticator
extends Authenticator {
    private static volatile DefaultAuthenticator instance;
    private final Map<Authenticator.RequestorType, Boolean> credentialsTried = new EnumMap<Authenticator.RequestorType, Boolean>(Authenticator.RequestorType.class);
    private boolean enabled = true;

    public static DefaultAuthenticator getInstance() {
        return instance;
    }

    public static void createInstance() {
        instance = new DefaultAuthenticator();
    }

    private DefaultAuthenticator() {
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (!this.enabled) {
            return null;
        }
        try {
            if (this.getRequestorType().equals((Object)Authenticator.RequestorType.SERVER) && OsmApi.isUsingOAuth()) {
                return null;
            }
            boolean bl = this.credentialsTried.get((Object)this.getRequestorType()) != null;
            CredentialsAgentResponse credentialsAgentResponse = CredentialsManager.getInstance().getCredentials(this.getRequestorType(), this.getRequestingHost(), bl);
            if (credentialsAgentResponse == null || credentialsAgentResponse.isCanceled()) {
                return null;
            }
            this.credentialsTried.put(this.getRequestorType(), Boolean.TRUE);
            return new PasswordAuthentication(credentialsAgentResponse.getUsername(), credentialsAgentResponse.getPassword());
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Main.error(credentialsAgentException);
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }
}

