/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.Property;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class PropertyMap
implements Map<Object, Property> {
    private final PropertyMap car;
    private final Property cdr;
    private final int size;
    private static final PropertyMap EMPTY = new PropertyMap();

    private PropertyMap() {
        this.car = null;
        this.cdr = null;
        this.size = 0;
    }

    private PropertyMap(PropertyMap parent, Property added) {
        this.car = Objects.requireNonNull(parent);
        this.cdr = added;
        this.size = parent.size + 1;
    }

    public static PropertyMap empty() {
        return EMPTY;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map.Entry<Object, Property> entry : this.reverseOrderEntrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<Object, Property> entry : this.reverseOrderEntrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Property get(Object key) {
        for (Map.Entry<Object, Property> entry : this.reverseOrderEntrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Property put(Object key, Property value) {
        throw PropertyMap.unmodifiableException();
    }

    @Override
    public Property remove(Object key) {
        throw PropertyMap.unmodifiableException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Property> m) {
        throw PropertyMap.unmodifiableException();
    }

    @Override
    public void clear() {
        throw PropertyMap.unmodifiableException();
    }

    @Override
    public Set<Object> keySet() {
        return new AbstractSet<Object>(){

            @Override
            public Iterator<Object> iterator() {
                Object[] keys = new Object[this.size()];
                Iterator<Map.Entry<Object, Property>> iterator = PropertyMap.this.reverseOrderEntrySet().iterator();
                int pos = this.size() - 1;
                while (pos >= 0) {
                    keys[pos] = iterator.next().getKey();
                    --pos;
                }
                return Arrays.asList(keys).iterator();
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    @Override
    public Collection<Property> values() {
        return new AbstractSet<Property>(){

            @Override
            public Iterator<Property> iterator() {
                Property[] values = new Property[this.size()];
                Iterator<Map.Entry<Object, Property>> iterator = PropertyMap.this.reverseOrderEntrySet().iterator();
                int pos = this.size() - 1;
                while (pos >= 0) {
                    values[pos] = iterator.next().getValue();
                    --pos;
                }
                return Arrays.asList(values).iterator();
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<Object, Property>> entrySet() {
        return new AbstractSet<Map.Entry<Object, Property>>(){

            @Override
            public Iterator<Map.Entry<Object, Property>> iterator() {
                Map.Entry[] entries = new Map.Entry[this.size()];
                Iterator<Map.Entry<Object, Property>> iterator = PropertyMap.this.reverseOrderEntrySet().iterator();
                int pos = this.size() - 1;
                while (pos >= 0) {
                    entries[pos] = iterator.next();
                    --pos;
                }
                return Arrays.asList(entries).iterator();
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    public Set<Map.Entry<Object, Property>> reverseOrderEntrySet() {
        return new AbstractSet<Map.Entry<Object, Property>>(){

            @Override
            public Iterator<Map.Entry<Object, Property>> iterator() {
                return new Iterator<Map.Entry<Object, Property>>(){
                    PropertyMap current;
                    {
                        this.current = PropertyMap.this;
                    }

                    @Override
                    public Map.Entry<Object, Property> next() {
                        if (this.hasNext()) {
                            try {
                                MapEntryImpl mapEntryImpl = new MapEntryImpl(this.current.cdr);
                                return mapEntryImpl;
                            }
                            finally {
                                this.current = this.current.car;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != PropertyMap.empty();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    public Set<Object> reverseOrderKeys() {
        return new AbstractSet<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    PropertyMap current;
                    {
                        this.current = PropertyMap.this;
                    }

                    @Override
                    public Object next() {
                        if (this.hasNext()) {
                            try {
                                Object object = this.current.cdr.getKey();
                                return object;
                            }
                            finally {
                                this.current = this.current.car;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != PropertyMap.empty();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    public Set<Property> reverseOrderValues() {
        return new AbstractSet<Property>(){

            @Override
            public Iterator<Property> iterator() {
                return new Iterator<Property>(){
                    PropertyMap current;
                    {
                        this.current = PropertyMap.this;
                    }

                    @Override
                    public Property next() {
                        if (this.hasNext()) {
                            try {
                                Property property = this.current.cdr;
                                return property;
                            }
                            finally {
                                this.current = this.current.car;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != PropertyMap.empty();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    private static UnsupportedOperationException unmodifiableException() {
        throw new UnsupportedOperationException("unmodifiable");
    }

    public PropertyMap putCopy(Property value) {
        assert (!this.containsValue(value));
        return new PropertyMap(this, value);
    }

    public PropertyMap removeCopy(Property value) {
        ArrayDeque<Property> shelve = new ArrayDeque<Property>();
        PropertyMap current = this;
        while (!current.isEmpty()) {
            if (current.getLastProperty().equals(value)) {
                PropertyMap newMap = current.getParentMap();
                for (Property property : shelve) {
                    newMap = newMap.putCopy(property);
                }
                return newMap;
            }
            shelve.push(current.getLastProperty());
            current = current.getParentMap();
        }
        return this;
    }

    public PropertyMap replaceCopy(Property oldValue, Property newValue) {
        ArrayDeque<Property> shelve = new ArrayDeque<Property>();
        PropertyMap current = this;
        while (!current.isEmpty()) {
            if (current.getLastProperty().equals(oldValue)) {
                PropertyMap newMap = current.getParentMap();
                newMap = newMap.putCopy(newValue);
                for (Property property : shelve) {
                    newMap = newMap.putCopy(property);
                }
                return newMap;
            }
            shelve.push(current.getLastProperty());
            current = current.getParentMap();
        }
        return this;
    }

    public PropertyMap getOwningMap(Property value) {
        PropertyMap current = this;
        while (!current.isEmpty()) {
            if (current.getLastProperty().equals(value)) {
                return current;
            }
            current = current.getParentMap();
        }
        return null;
    }

    PropertyMap getParentMap() {
        return this.car;
    }

    public Property getLastProperty() {
        return this.cdr;
    }

    private static final class MapEntryImpl
    implements Map.Entry<Object, Property> {
        private final Property backingProperty;

        public MapEntryImpl(Property backingProperty) {
            this.backingProperty = backingProperty;
        }

        @Override
        public Object getKey() {
            return this.backingProperty.getKey();
        }

        @Override
        public Property getValue() {
            return this.backingProperty;
        }

        @Override
        public Property setValue(Property value) {
            throw PropertyMap.unmodifiableException();
        }
    }
}

