/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class ReadRemainingArgumentsNode
extends RubyNode {
    private final int start;
    private final ConditionProfile remainingArguments = ConditionProfile.createBinaryProfile();

    public ReadRemainingArgumentsNode(RubyContext context, SourceSection sourceSection, int start) {
        super(context, sourceSection);
        this.start = start;
    }

    @Override
    public Object[] executeObjectArray(VirtualFrame frame) {
        int count = RubyArguments.getUserArgumentsCount(frame.getArguments());
        if (this.remainingArguments.profile(this.start < count)) {
            return RubyArguments.extractUserArgumentsFrom(frame.getArguments(), this.start);
        }
        return new Object[0];
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeObjectArray(frame);
    }
}

