/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.ArrayReflector;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="otherSize"), @NodeChild(value="other")})
public abstract class AppendManyNode
extends RubyNode {
    public AppendManyNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeAppendMany(DynamicObject var1, int var2, Object var3);

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public DynamicObject appendManyEmpty(DynamicObject array, int otherSize, int[] other) {
        Layouts.ARRAY.setStore(array, Arrays.copyOf(other, otherSize));
        Layouts.ARRAY.setSize(array, otherSize);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public DynamicObject appendManyEmpty(DynamicObject array, int otherSize, long[] other) {
        Layouts.ARRAY.setStore(array, Arrays.copyOf(other, otherSize));
        Layouts.ARRAY.setSize(array, otherSize);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public DynamicObject appendManyEmpty(DynamicObject array, int otherSize, double[] other) {
        Layouts.ARRAY.setStore(array, Arrays.copyOf(other, otherSize));
        Layouts.ARRAY.setSize(array, otherSize);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public DynamicObject appendManyEmpty(DynamicObject array, int otherSize, Object[] other) {
        Layouts.ARRAY.setStore(array, Arrays.copyOf(other, otherSize));
        Layouts.ARRAY.setSize(array, otherSize);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public DynamicObject appendManySameType(DynamicObject array, int otherSize, int[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManySameTypeGeneric(array, ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public DynamicObject appendManySameType(DynamicObject array, int otherSize, long[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManySameTypeGeneric(array, ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public DynamicObject appendManySameType(DynamicObject array, int otherSize, double[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManySameTypeGeneric(array, ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public DynamicObject appendManySameType(DynamicObject array, int otherSize, Object[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManySameTypeGeneric(array, ArrayReflector.reflect((Object[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other), extendProfile);
        return array;
    }

    public void appendManySameTypeGeneric(DynamicObject array, ArrayMirror storeMirror, int otherSize, ArrayMirror otherStoreMirror, ConditionProfile extendProfile) {
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + otherSize;
        ArrayMirror newStoreMirror = extendProfile.profile(newSize > storeMirror.getLength()) ? storeMirror.copyArrayAndMirror(ArrayUtils.capacity(storeMirror.getLength(), newSize)) : storeMirror;
        otherStoreMirror.copyTo(newStoreMirror, 0, oldSize, otherSize);
        Layouts.ARRAY.setStore(array, newStoreMirror.getArray());
        Layouts.ARRAY.setSize(array, newSize);
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public DynamicObject appendManyBoxIntoObject(DynamicObject array, int otherSize, int[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManyBoxIntoObjectGeneric(array, otherSize, ArrayReflector.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public DynamicObject appendManyBoxIntoObject(DynamicObject array, int otherSize, long[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManyBoxIntoObjectGeneric(array, otherSize, ArrayReflector.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public DynamicObject appendManyBoxIntoObject(DynamicObject array, int otherSize, double[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManyBoxIntoObjectGeneric(array, otherSize, ArrayReflector.reflect(other), extendProfile);
        return array;
    }

    public void appendManyBoxIntoObjectGeneric(DynamicObject array, int otherSize, ArrayMirror otherStoreMirror, ConditionProfile extendProfile) {
        Object[] oldStore;
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + otherSize;
        Object[] newStore = extendProfile.profile(newSize > (oldStore = (Object[])Layouts.ARRAY.getStore(array)).length) ? ArrayUtils.grow(oldStore, ArrayUtils.capacity(oldStore.length, newSize)) : oldStore;
        otherStoreMirror.copyTo(newStore, 0, oldSize, otherSize);
        Layouts.ARRAY.setStore(array, newStore);
        Layouts.ARRAY.setSize(array, newSize);
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public DynamicObject appendManyLongIntoInteger(DynamicObject array, int otherSize, long[] other) {
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + otherSize;
        int[] oldStore = (int[])Layouts.ARRAY.getStore(array);
        long[] newStore = ArrayUtils.longCopyOf(oldStore, ArrayUtils.capacity(oldStore.length, newSize));
        System.arraycopy(other, 0, newStore, oldSize, otherSize);
        Layouts.ARRAY.setStore(array, newStore);
        Layouts.ARRAY.setSize(array, newSize);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public DynamicObject appendManyGeneralizeIntegerDouble(DynamicObject array, int otherSize, double[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other));
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public DynamicObject appendManyGeneralizeIntegerDouble(DynamicObject array, int otherSize, Object[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other));
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public DynamicObject appendManyGeneralizeLongDouble(DynamicObject array, int otherSize, double[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other));
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public DynamicObject appendManyGeneralizeLongDouble(DynamicObject array, int otherSize, Object[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other));
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public DynamicObject appendManyGeneralizeDoubleInteger(DynamicObject array, int otherSize, int[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other));
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public DynamicObject appendManyGeneralizeDoubleLong(DynamicObject array, int otherSize, long[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other));
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public DynamicObject appendManyGeneralizeDoubleObject(DynamicObject array, int otherSize, Object[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array)), otherSize, ArrayReflector.reflect(other));
        return array;
    }

    public void appendManyGeneralizeGeneric(DynamicObject array, ArrayMirror storeMirror, int otherSize, ArrayMirror otherStoreMirror) {
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + otherSize;
        Object[] newStore = storeMirror.getBoxedCopy(ArrayUtils.capacity(storeMirror.getLength(), newSize));
        otherStoreMirror.copyTo(newStore, 0, oldSize, otherSize);
        Layouts.ARRAY.setStore(array, newStore);
        Layouts.ARRAY.setSize(array, newSize);
    }
}

