/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.exceptions.RescueNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class RescueSplatNode
extends RescueNode {
    @Node.Child
    RubyNode handlingClassesArray;

    public RescueSplatNode(RubyContext context, SourceSection sourceSection, RubyNode handlingClassesArray, RubyNode body) {
        super(context, sourceSection, body);
        this.handlingClassesArray = handlingClassesArray;
    }

    @Override
    public boolean canHandle(VirtualFrame frame, DynamicObject exception) {
        CompilerDirectives.transferToInterpreter();
        DynamicObject handlingClasses = (DynamicObject)this.handlingClassesArray.execute(frame);
        DynamicObject exceptionRubyClass = Layouts.BASIC_OBJECT.getLogicalClass(exception);
        for (Object handlingClass : ArrayOperations.toIterable(handlingClasses)) {
            if (!ModuleOperations.assignableTo(exceptionRubyClass, (DynamicObject)handlingClass)) continue;
            return true;
        }
        return false;
    }
}

