/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.util.Arrays;
import java.util.Set;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;

public class AnnotationHelper {
    public static void addMethodNamesToSet(Set<String> set, JRubyMethod jrubyMethod, String simpleName) {
        if (jrubyMethod.name().length == 0) {
            set.add(simpleName);
        } else {
            set.addAll(Arrays.asList(jrubyMethod.name()));
        }
        if (jrubyMethod.alias().length > 0) {
            set.addAll(Arrays.asList(jrubyMethod.alias()));
        }
    }

    public static int getArityValue(JRubyMethod anno, int actualRequired) {
        if (anno.optional() > 0 || anno.rest()) {
            return -(actualRequired + 1);
        }
        return actualRequired;
    }

    public static String getCallerCallConfigNameByAnno(JRubyMethod jrubyMethod) {
        boolean frame = false;
        boolean scope = false;
        for (FrameField field2 : jrubyMethod.reads()) {
            frame |= field2.needsFrame();
            scope |= field2.needsScope();
        }
        for (FrameField field2 : jrubyMethod.writes()) {
            frame |= field2.needsFrame();
            scope |= field2.needsScope();
        }
        return AnnotationHelper.getCallConfigName(frame, scope);
    }

    public static String getCallConfigNameByAnno(JRubyMethod jrubyMethod) {
        return AnnotationHelper.getCallConfigName(jrubyMethod.frame(), jrubyMethod.scope());
    }

    public static String getCallConfigName(boolean frame, boolean scope) {
        if (frame) {
            if (scope) {
                return "FrameFullScopeFull";
            }
            return "FrameFullScopeNone";
        }
        if (scope) {
            return "FrameNoneScopeFull";
        }
        return "FrameNoneScopeNone";
    }
}

