/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.contrib.AutoscrollHelper;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.FigureSelectionListener;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardFigureSelection;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.UndoableCommand;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PrinterGraphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.plaf.PanelUI;

public class StandardDrawingView
extends JPanel
implements DrawingView,
KeyListener,
Autoscroll {
    private transient DrawingEditor fEditor;
    private transient Vector fSelectionListeners;
    private Drawing fDrawing;
    private transient Rectangle fDamage = null;
    private transient Vector fSelection;
    private transient Vector fSelectionHandles;
    private Dimension fViewSize;
    private Point fLastClick;
    private Vector fBackgrounds = null;
    private Vector fForegrounds = null;
    private Painter fUpdateStrategy;
    private PointConstrainer fConstrainer;
    public static final int MINIMUM_WIDTH = 400;
    public static final int MINIMUM_HEIGHT = 300;
    public static final int SCROLL_INCR = 100;
    public static final int SCROLL_OFFSET = 10;
    private static final long serialVersionUID = -3878153366174603336L;
    private int drawingViewSerializedDataVersion = 1;
    private ASH ash = new ASH(10);
    static int counter;
    int myCounter = counter++;

    public StandardDrawingView(DrawingEditor editor) {
        this(editor, 400, 300);
    }

    public StandardDrawingView(DrawingEditor editor, int width, int height) {
        super(null);
        this.setAutoscrolls(true);
        this.fEditor = editor;
        this.fViewSize = new Dimension(width, height);
        this.fSelectionListeners = new Vector();
        this.addFigureSelectionListener(this.editor());
        this.fLastClick = new Point(0, 0);
        this.fConstrainer = null;
        this.fSelection = new Vector();
        this.setDisplayUpdate(new SimpleUpdateStrategy());
        this.setBackground(Color.lightGray);
        MouseListener ml = this.createMouseListener();
        MouseMotionListener mml = this.createMouseMotionListener();
        this.addMouseListener(ml);
        this.addMouseMotionListener(mml);
        this.addKeyListener(this);
    }

    protected MouseListener createMouseListener() {
        return new DrawingViewMouseListener();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new DrawingViewMouseMotionListener();
    }

    public void setEditor(DrawingEditor editor) {
        this.fEditor = editor;
    }

    public Tool tool() {
        return this.editor().tool();
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public void setDrawing(Drawing d) {
        if (this.fDrawing != null) {
            this.clearSelection();
            this.fDrawing.removeDrawingChangeListener(this);
        }
        this.fDrawing = d;
        if (this.fDrawing != null) {
            this.fDrawing.addDrawingChangeListener(this);
        }
        this.checkMinimumSize();
        this.repaint();
    }

    public DrawingEditor editor() {
        return this.fEditor;
    }

    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    public void addAll(Vector figures) {
        FigureEnumerator k = new FigureEnumerator(figures);
        while (k.hasMoreElements()) {
            this.add(k.nextFigure());
        }
    }

    public boolean figureExists(Figure inf, FigureEnumeration e) {
        while (e.hasMoreElements()) {
            Figure figure = e.nextFigure();
            if (!figure.includes(inf)) continue;
            return true;
        }
        return false;
    }

    public FigureEnumeration insertFigures(FigureEnumeration fe, int dx, int dy, boolean bCheck) {
        if (fe == null) {
            return FigureEnumerator.getEmptyEnumeration();
        }
        Vector<Figure> addedFigures = new Vector<Figure>();
        Vector<Figure> vCF = new Vector<Figure>(10);
        while (fe.hasMoreElements()) {
            Figure figure = fe.nextFigure();
            if (figure instanceof ConnectionFigure) {
                vCF.addElement(figure);
                continue;
            }
            if (figure == null) continue;
            figure.moveBy(dx, dy);
            figure = this.add(figure);
            this.addToSelection(figure);
            addedFigures.addElement(figure);
        }
        FigureEnumerator ecf = new FigureEnumerator(vCF);
        while (ecf.hasMoreElements()) {
            ConnectionFigure cf = (ConnectionFigure)ecf.nextFigure();
            Figure sf = cf.startFigure();
            Figure ef = cf.endFigure();
            if (!this.figureExists(sf, this.drawing().figures()) || !this.figureExists(ef, this.drawing().figures()) || bCheck && !cf.canConnect(sf, ef)) continue;
            if (bCheck) {
                Point sp = sf.center();
                Point ep = ef.center();
                Connector fStartConnector = cf.startFigure().connectorAt(ep.x, ep.y);
                Connector fEndConnector = cf.endFigure().connectorAt(sp.x, sp.y);
                if (fEndConnector != null && fStartConnector != null) {
                    cf.connectStart(fStartConnector);
                    cf.connectEnd(fEndConnector);
                    cf.updateConnection();
                }
            }
            Figure nf = this.add(cf);
            this.addToSelection(nf);
            addedFigures.addElement(nf);
        }
        return new FigureEnumerator(addedFigures);
    }

    public Vector getConnectionFigures(Figure inFigure) {
        if (inFigure == null || !inFigure.canConnect()) {
            return null;
        }
        Vector<Figure> result = new Vector<Figure>(5);
        FigureEnumeration figures = this.drawing().figures();
        while (figures.hasMoreElements()) {
            ConnectionFigure cf;
            Figure f = figures.nextFigure();
            if (!(f instanceof ConnectionFigure) || this.isFigureSelected(f) || !(cf = (ConnectionFigure)f).startFigure().includes(inFigure) && !cf.endFigure().includes(inFigure)) continue;
            result.addElement(f);
        }
        return result;
    }

    public Dimension getMinimumSize() {
        return this.fViewSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setDisplayUpdate(Painter updateStrategy) {
        this.fUpdateStrategy = updateStrategy;
    }

    public Painter getDisplayUpdate() {
        return this.fUpdateStrategy;
    }

    public Vector selection() {
        return (Vector)this.fSelection.clone();
    }

    public FigureEnumeration selectionElements() {
        return new FigureEnumerator(this.selectionZOrdered());
    }

    public Vector selectionZOrdered() {
        Vector<Figure> result = new Vector<Figure>(this.selectionCount());
        FigureEnumeration figures = this.drawing().figures();
        while (figures.hasMoreElements()) {
            Figure f = figures.nextFigure();
            if (!this.isFigureSelected(f)) continue;
            result.addElement(f);
        }
        return result;
    }

    public int selectionCount() {
        return this.fSelection.size();
    }

    public boolean isFigureSelected(Figure checkFigure) {
        return this.fSelection.contains(checkFigure);
    }

    public void addToSelection(Figure figure) {
        if (!this.isFigureSelected(figure) && this.drawing().includes(figure)) {
            this.fSelection.addElement(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.fireSelectionChanged();
        }
    }

    public void addToSelectionAll(Vector figures) {
        this.addToSelectionAll(new FigureEnumerator(figures));
    }

    public void addToSelectionAll(FigureEnumeration fe) {
        while (fe.hasMoreElements()) {
            this.addToSelection(fe.nextFigure());
        }
    }

    public void removeFromSelection(Figure figure) {
        if (this.isFigureSelected(figure)) {
            this.fSelection.removeElement(figure);
            this.fSelectionHandles = null;
            figure.invalidate();
            this.fireSelectionChanged();
        }
    }

    public void toggleSelection(Figure figure) {
        if (this.isFigureSelected(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
        this.fireSelectionChanged();
    }

    public void clearSelection() {
        if (this.fSelectionHandles == null) {
            return;
        }
        FigureEnumeration fe = this.selectionElements();
        while (fe.hasMoreElements()) {
            fe.nextFigure().invalidate();
        }
        this.fSelection = new Vector();
        this.fSelectionHandles = null;
        this.fireSelectionChanged();
    }

    private Enumeration selectionHandles() {
        if (this.fSelectionHandles == null) {
            this.fSelectionHandles = new Vector();
            FigureEnumeration k = this.selectionElements();
            while (k.hasMoreElements()) {
                Figure figure = k.nextFigure();
                Enumeration kk = figure.handles().elements();
                while (kk.hasMoreElements()) {
                    this.fSelectionHandles.addElement(kk.nextElement());
                }
            }
        }
        return this.fSelectionHandles.elements();
    }

    public FigureSelection getFigureSelection() {
        return new StandardFigureSelection(new FigureEnumerator(this.selectionZOrdered()), this.selectionCount());
    }

    public Handle findHandle(int x, int y) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            Handle handle = (Handle)k.nextElement();
            if (!handle.containsPoint(x, y)) continue;
            return handle;
        }
        return null;
    }

    protected void fireSelectionChanged() {
        if (this.fSelectionListeners != null) {
            for (int i = 0; i < this.fSelectionListeners.size(); ++i) {
                FigureSelectionListener l = (FigureSelectionListener)this.fSelectionListeners.elementAt(i);
                l.figureSelectionChanged(this);
            }
        }
    }

    public Point lastClick() {
        return this.fLastClick;
    }

    public void setConstrainer(PointConstrainer c) {
        this.fConstrainer = c;
    }

    public PointConstrainer getConstrainer() {
        return this.fConstrainer;
    }

    protected Point constrainPoint(Point p) {
        Dimension size = this.getSize();
        p.x = Geom.range(1, size.width, p.x);
        p.y = Geom.range(1, size.height, p.y);
        if (this.fConstrainer != null) {
            return this.fConstrainer.constrainPoint(p);
        }
        return p;
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 8 || code == 127) {
            UndoableCommand cmd = new UndoableCommand(new DeleteCommand("Delete", this.editor()));
            if (cmd.isExecutable()) {
                cmd.execute();
            }
        } else if (code == 40 || code == 38 || code == 39 || code == 37) {
            this.handleCursorKey(code);
        } else {
            this.tool().keyDown(e, code);
        }
        this.checkDamage();
    }

    protected void handleCursorKey(int key) {
        int dx = 0;
        int dy = 0;
        int stepX = 1;
        int stepY = 1;
        if (this.fConstrainer != null) {
            stepX = this.fConstrainer.getStepX();
            stepY = this.fConstrainer.getStepY();
        }
        switch (key) {
            case 40: {
                dy = stepY;
                break;
            }
            case 38: {
                dy = -stepY;
                break;
            }
            case 39: {
                dx = stepX;
                break;
            }
            case 37: {
                dx = -stepX;
            }
        }
        this.moveSelection(dx, dy);
    }

    private void moveSelection(int dx, int dy) {
        FigureEnumeration figures = this.selectionElements();
        while (figures.hasMoreElements()) {
            figures.nextFigure().moveBy(dx, dy);
        }
        this.checkDamage();
    }

    public synchronized void checkDamage() {
        Enumeration each = this.drawing().drawingChangeListeners();
        while (each.hasMoreElements()) {
            Object l = each.nextElement();
            if (!(l instanceof DrawingView)) continue;
            ((DrawingView)l).repairDamage();
        }
    }

    public void repairDamage() {
        if (this.fDamage != null) {
            this.repaint(this.fDamage.x, this.fDamage.y, this.fDamage.width, this.fDamage.height);
            this.fDamage = null;
        }
    }

    public void drawingInvalidated(DrawingChangeEvent e) {
        Rectangle r = e.getInvalidatedRectangle();
        if (this.fDamage == null) {
            this.fDamage = r;
        } else {
            this.fDamage.add(r);
        }
    }

    public void drawingRequestUpdate(DrawingChangeEvent e) {
        this.repairDamage();
    }

    protected void paintComponent(Graphics g) {
        this.getDisplayUpdate().draw(g, this);
    }

    public void drawAll(Graphics g) {
        boolean isPrinting = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        this.drawBackground(g);
        if (this.fBackgrounds != null && !isPrinting) {
            this.drawPainters(g, this.fBackgrounds);
        }
        this.drawDrawing(g);
        if (this.fForegrounds != null && !isPrinting) {
            this.drawPainters(g, this.fForegrounds);
        }
        if (!isPrinting) {
            this.drawHandles(g);
        }
    }

    public void draw(Graphics g, FigureEnumeration fe) {
        boolean isPrinting = g instanceof PrintGraphics;
        if (this.fBackgrounds != null && !isPrinting) {
            this.drawPainters(g, this.fBackgrounds);
        }
        this.fDrawing.draw(g, fe);
        if (this.fForegrounds != null && !isPrinting) {
            this.drawPainters(g, this.fForegrounds);
        }
        if (!isPrinting) {
            this.drawHandles(g);
        }
    }

    public void drawHandles(Graphics g) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            ((Handle)k.nextElement()).draw(g);
        }
    }

    public void drawDrawing(Graphics g) {
        this.fDrawing.draw(g);
    }

    public void drawBackground(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
    }

    private void drawPainters(Graphics g, Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            ((Painter)v.elementAt(i)).draw(g, this);
        }
    }

    public void addBackground(Painter painter) {
        if (this.fBackgrounds == null) {
            this.fBackgrounds = new Vector(3);
        }
        this.fBackgrounds.addElement(painter);
        this.repaint();
    }

    public void removeBackground(Painter painter) {
        if (this.fBackgrounds != null) {
            this.fBackgrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void removeForeground(Painter painter) {
        if (this.fForegrounds != null) {
            this.fForegrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this.fForegrounds == null) {
            this.fForegrounds = new Vector(3);
        }
        this.fForegrounds.addElement(painter);
        this.repaint();
    }

    public void freezeView() {
        this.drawing().lock();
    }

    public void unfreezeView() {
        this.drawing().unlock();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fSelection = new Vector();
        if (this.fDrawing != null) {
            this.fDrawing.addDrawingChangeListener(this);
        }
        this.fSelectionListeners = new Vector();
    }

    private void checkMinimumSize() {
        FigureEnumeration k = this.drawing().figures();
        Dimension d = new Dimension(0, 0);
        while (k.hasMoreElements()) {
            Rectangle r = k.nextFigure().displayBox();
            d.width = Math.max(d.width, r.x + r.width);
            d.height = Math.max(d.height, r.y + r.height);
        }
        if (this.fViewSize.height < d.height || this.fViewSize.width < d.width) {
            this.fViewSize.height = d.height + 10;
            this.fViewSize.width = d.width + 10;
            this.setSize(this.fViewSize);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isInteractive() {
        return true;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void addFigureSelectionListener(FigureSelectionListener fsl) {
        this.fSelectionListeners.add(fsl);
    }

    public void removeFigureSelectionListener(FigureSelectionListener fsl) {
        this.fSelectionListeners.remove(fsl);
    }

    public int getDefaultDNDActions() {
        return 3;
    }

    public void autoscroll(Point p) {
        this.ash.autoscroll(p);
    }

    public Insets getAutoscrollInsets() {
        return this.ash.getAutoscrollInsets();
    }

    public String toString() {
        return "DrawingView Nr: " + this.myCounter;
    }

    public PanelUI getUI() {
        return null;
    }

    public void setUI(PanelUI ui) {
    }

    public class DrawingViewMouseMotionListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent e) {
            Point p = StandardDrawingView.this.constrainPoint(new Point(e.getX(), e.getY()));
            StandardDrawingView.this.tool().mouseDrag(e, p.x, p.y);
            StandardDrawingView.this.checkDamage();
        }

        public void mouseMoved(MouseEvent e) {
            StandardDrawingView.this.tool().mouseMove(e, e.getX(), e.getY());
        }
    }

    public class DrawingViewMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            StandardDrawingView.this.requestFocus();
            Point p = StandardDrawingView.this.constrainPoint(new Point(e.getX(), e.getY()));
            StandardDrawingView.this.fLastClick = new Point(e.getX(), e.getY());
            StandardDrawingView.this.tool().mouseDown(e, p.x, p.y);
            StandardDrawingView.this.checkDamage();
        }

        public void mouseReleased(MouseEvent e) {
            Point p = StandardDrawingView.this.constrainPoint(new Point(e.getX(), e.getY()));
            StandardDrawingView.this.tool().mouseUp(e, p.x, p.y);
            StandardDrawingView.this.checkDamage();
        }
    }

    class ASH
    extends AutoscrollHelper {
        public ASH(int margin) {
            super(margin);
        }

        public Dimension getSize() {
            return StandardDrawingView.this.getSize();
        }

        public Rectangle getVisibleRect() {
            return StandardDrawingView.this.getVisibleRect();
        }

        public void scrollRectToVisible(Rectangle aRect) {
            StandardDrawingView.this.scrollRectToVisible(aRect);
        }
    }
}

