/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.StartSegment;
import ch.interlis.iom_j.itf.impl.jtsext.StraightSegment;
import ch.interlis.iox_j.jts.Iox2jtsException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKBWriter;
import java.util.ArrayList;

public class Iox2jts {
    private Iox2jts() {
    }

    public static String coord2hexwkb(IomObject value) throws Iox2jtsException {
        if (value != null) {
            Point geom = new GeometryFactory().createPoint(Iox2jts.coord2JTS(value));
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static String polyline2hexwkb(IomObject value, double p) throws Iox2jtsException {
        if (value != null) {
            CompoundCurve geom = Iox2jts.polyline2JTS(value, false, p);
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static String surface2hexwkb(IomObject value, double strokeP) throws Iox2jtsException {
        if (value != null) {
            Polygon geom = Iox2jts.surface2JTS(value, strokeP);
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static Coordinate coord2JTS(IomObject value) throws Iox2jtsException {
        double yCoord;
        double xCoord;
        if (value == null) {
            return null;
        }
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2jtsException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2jtsException("failed to read C2 <" + c2 + ">", ex);
        }
        Coordinate coord = null;
        if (c3 == null) {
            coord = new Coordinate(xCoord, yCoord);
        } else {
            double zCoord;
            try {
                zCoord = Double.parseDouble(c3);
            }
            catch (Exception ex) {
                throw new Iox2jtsException("failed to read C3 <" + c3 + ">", ex);
            }
            coord = new Coordinate(xCoord, yCoord, zCoord);
        }
        return coord;
    }

    public static CompoundCurve polyline2JTS(IomObject polylineObj, boolean isSurfaceOrArea, double p) throws Iox2jtsException {
        boolean clipped;
        IomObject lineattr;
        if (polylineObj == null) {
            return null;
        }
        ArrayList<CurveSegment> ret = new ArrayList<CurveSegment>();
        if (isSurfaceOrArea && (lineattr = polylineObj.getattrobj("lineattr", 0)) != null) {
            throw new Iox2jtsException("Lineattributes not supported");
        }
        boolean bl = clipped = polylineObj.getobjectconsistency() == 1;
        if (clipped) {
            throw new Iox2jtsException("clipped polyline not supported");
        }
        int sequencei = 0;
        while (sequencei < polylineObj.getattrvaluecount("sequence")) {
            if (!clipped && sequencei > 0) {
                throw new Iox2jtsException("unclipped polyline with multi 'sequence' elements");
            }
            Coordinate lastSegmentEndpoint = null;
            IomObject sequence = polylineObj.getattrobj("sequence", sequencei);
            int segmenti = 0;
            while (segmenti < sequence.getattrvaluecount("segment")) {
                IomObject segment = sequence.getattrobj("segment", segmenti);
                CurveSegment curve = null;
                if (segment.getobjecttag().equals("COORD")) {
                    curve = lastSegmentEndpoint == null ? new StartSegment(segment) : new StraightSegment(lastSegmentEndpoint, segment);
                } else if (segment.getobjecttag().equals("ARC")) {
                    curve = new ArcSegment(lastSegmentEndpoint, segment);
                } else {
                    throw new Iox2jtsException("custom line form not supported");
                }
                ret.add(curve);
                lastSegmentEndpoint = curve.getEndPoint();
                ++segmenti;
            }
            ++sequencei;
        }
        return new CompoundCurve(ret, new GeometryFactory());
    }

    public static Polygon surface2JTS(IomObject obj, double strokeP) throws Iox2jtsException {
        boolean clipped;
        if (obj == null) {
            return null;
        }
        Polygon ret = null;
        boolean bl = clipped = obj.getobjectconsistency() == 1;
        if (clipped) {
            throw new Iox2jtsException("clipped surface not supported");
        }
        int surfacei = 0;
        while (surfacei < obj.getattrvaluecount("surface")) {
            if (!clipped && surfacei > 0) {
                throw new Iox2jtsException("unclipped surface with multi 'surface' elements");
            }
            IomObject surface = obj.getattrobj("surface", surfacei);
            CompoundCurveRing shell = null;
            LinearRing[] holes = null;
            int boundaryc = surface.getattrvaluecount("boundary");
            if (boundaryc > 1) {
                holes = new CompoundCurveRing[boundaryc - 1];
            }
            int boundaryi = 0;
            while (boundaryi < boundaryc) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                ArrayList<CompoundCurve> jtsLine = new ArrayList<CompoundCurve>();
                int polylinei = 0;
                while (polylinei < boundary.getattrvaluecount("polyline")) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    jtsLine.add(Iox2jts.polyline2JTS(polyline, true, strokeP));
                    ++polylinei;
                }
                if (boundaryi == 0) {
                    shell = new CompoundCurveRing(jtsLine, new GeometryFactory());
                } else {
                    holes[boundaryi - 1] = new CompoundCurveRing(jtsLine, new GeometryFactory());
                }
                ++boundaryi;
            }
            ret = new GeometryFactory().createPolygon(shell, holes);
            ++surfacei;
        }
        return ret;
    }
}

