/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;

public class TableDirectory {
    private int version = 0;
    private short numTables = 0;
    private short searchRange = 0;
    private short entrySelector = 0;
    private short rangeShift = 0;
    private DirectoryEntry[] entries;

    public TableDirectory(RandomAccessFile raf) throws IOException {
        this.version = raf.readInt();
        this.numTables = raf.readShort();
        this.searchRange = raf.readShort();
        this.entrySelector = raf.readShort();
        this.rangeShift = raf.readShort();
        this.entries = new DirectoryEntry[this.numTables];
        int i = 0;
        while (i < this.numTables) {
            this.entries[i] = new DirectoryEntry(raf);
            ++i;
        }
        boolean modified = true;
        while (modified) {
            modified = false;
            int i2 = 0;
            while (i2 < this.numTables - 1) {
                if (this.entries[i2].getOffset() > this.entries[i2 + 1].getOffset()) {
                    DirectoryEntry temp = this.entries[i2];
                    this.entries[i2] = this.entries[i2 + 1];
                    this.entries[i2 + 1] = temp;
                    modified = true;
                }
                ++i2;
            }
        }
    }

    public DirectoryEntry getEntry(int index) {
        return this.entries[index];
    }

    public DirectoryEntry getEntryByTag(int tag) {
        int i = 0;
        while (i < this.numTables) {
            if (this.entries[i].getTag() == tag) {
                return this.entries[i];
            }
            ++i;
        }
        return null;
    }

    public short getEntrySelector() {
        return this.entrySelector;
    }

    public short getNumTables() {
        return this.numTables;
    }

    public short getRangeShift() {
        return this.rangeShift;
    }

    public short getSearchRange() {
        return this.searchRange;
    }

    public int getVersion() {
        return this.version;
    }
}

