/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.io;

import com.baselet.control.config.Config;
import com.baselet.control.enums.Program;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class OpenFileChooser {
    private JFileChooser fileChooser = new JFileChooser(Config.getInstance().getOpenFileHome());

    public OpenFileChooser() {
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("." + Program.getInstance().getExtension()) || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return String.valueOf(Program.getInstance().getProgramName()) + " diagram format (*." + Program.getInstance().getExtension() + ")";
            }
        });
        this.fileChooser.setAcceptAllFileFilterUsed(false);
    }

    public List<String> getFilesToOpen(Frame mainFrame) {
        ArrayList<String> fileNames = new ArrayList<String>();
        int returnVal = this.fileChooser.showOpenDialog(mainFrame);
        if (returnVal == 0) {
            File[] selectedFiles;
            File[] fileArray = selectedFiles = this.fileChooser.getSelectedFiles();
            int n = selectedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                fileNames.add(file.getAbsolutePath());
                ++n2;
            }
        }
        return fileNames;
    }
}

