/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;

public class SubStateSymbolFacet
extends KeyValueFacet {
    public static final SubStateSymbolFacet INSTANCE = new SubStateSymbolFacet();
    private static final int DIST_RIGHT = 15;
    private static final int DIST_BOTTOM = 5;

    private SubStateSymbolFacet() {
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("symbol", new KeyValueFacet.ValueInfo((Object)SubStateSymbolEnum.SUBSTATE, "draw a substate symbol in the lower right corner"));
    }

    @Override
    public void handleValue(String string, PropertiesParserState propertiesParserState) {
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        drawHandler.setLayer(DrawHandler.Layer.Foreground);
        ColorOwn colorOwn = drawHandler.getBackgroundColor();
        drawHandler.setBackgroundColor(ColorOwn.TRANSPARENT);
        SubStateSymbolEnum subStateSymbolEnum = SubStateSymbolEnum.valueOf(string.toUpperCase());
        double d = propertiesParserState.getGridElementSize().getWidth();
        double d2 = propertiesParserState.getGridElementSize().getHeight();
        if (subStateSymbolEnum == SubStateSymbolEnum.SUBSTATE) {
            double d3 = drawHandler.getFontSize() * 1.6;
            double d4 = d3 * 0.4;
            double d5 = d3 * 0.15;
            double d6 = d4;
            drawHandler.drawRectangleRound(d - 15.0 - d3, d2 - 5.0 - d4, d3, d4, d5);
            drawHandler.drawRectangleRound(d - 15.0 - d3 - d3 - d6, d2 - 5.0 - d4, d3, d4, d5);
            drawHandler.drawLine(d - 15.0 - d3 - d6, d2 - 5.0 - d4 / 2.0, d - 15.0 - d3, d2 - 5.0 - d4 / 2.0);
            drawHandler.setLayer(DrawHandler.Layer.Background);
            drawHandler.setBackgroundColor(colorOwn);
        }
    }

    private static enum SubStateSymbolEnum {
        SUBSTATE;

    }
}

