/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.facet;

import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Priority;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.FirstRunFacet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.relation.facet.LineDescriptionPositionFacet;
import com.baselet.element.relation.facet.LineDescriptionUtils;
import com.baselet.element.relation.facet.SettingsRelation;
import com.baselet.element.relation.helper.LineDescriptionEnum;
import com.baselet.element.relation.helper.RelationPointHandler;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LineDescriptionFacet
extends FirstRunFacet {
    static final int X_DIST_TO_LINE = 4;
    static final int LOWER_Y_DIST_TO_LINE = 1;
    static final int UPPER_Y_DIST_TO_LINE = 5;
    static final int MIDDLE_DISTANCE_TO_LINE = 4;
    public static final LineDescriptionFacet INSTANCE = new LineDescriptionFacet();

    private LineDescriptionFacet() {
    }

    @Override
    public boolean checkStart(String string, PropertiesParserState propertiesParserState) {
        return !string.startsWith("lt=");
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Arrays.asList(new AutocompletionText(LineDescriptionEnum.MESSAGE_START.getKey() + "=", "message at start"), new AutocompletionText(LineDescriptionEnum.MESSAGE_END.getKey() + "=", "message at end"), new AutocompletionText(LineDescriptionEnum.ROLE_START.getKey() + "=", "role at start"), new AutocompletionText(LineDescriptionEnum.ROLE_END.getKey() + "=", "role at end"));
    }

    @Override
    public void handleLine(String string, PropertiesParserState propertiesParserState) {
    }

    private RelationPointHandler getRelationPoints(PropertiesParserState propertiesParserState) {
        return ((SettingsRelation)propertiesParserState.getSettings()).getRelationPoints();
    }

    private void printAndUpdateIndex(DrawHandler drawHandler, RelationPointHandler relationPointHandler, PointDouble pointDouble, int n, String string, Point point, Set<Integer> set) {
        if (point != null) {
            pointDouble = new PointDouble(pointDouble.getX() + (double)point.getX(), pointDouble.getY() + (double)point.getY());
        }
        this.printAndUpdateIndex(drawHandler, relationPointHandler, pointDouble, n, string, set);
    }

    private void printAndUpdateIndex(DrawHandler drawHandler, RelationPointHandler relationPointHandler, PointDouble pointDouble, int n, String string, Set<Integer> set) {
        drawHandler.print(string, pointDouble, AlignHorizontal.LEFT);
        relationPointHandler.setTextBox(n, new Rectangle(pointDouble.getX(), pointDouble.getY() - drawHandler.textHeightMax(), drawHandler.textWidth(string), drawHandler.textHeightMax()));
        set.add(n);
    }

    @Override
    public void parsingFinished(PropertiesParserState propertiesParserState, List<String> list) {
        Object object;
        Map map = propertiesParserState.getOrInitFacetResponse(LineDescriptionPositionFacet.class, new HashMap());
        RelationPointHandler relationPointHandler = this.getRelationPoints(propertiesParserState);
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : list) {
            if (LineDescriptionEnum.forString(string) == LineDescriptionEnum.MESSAGE_MIDDLE) {
                arrayList.add(string);
                continue;
            }
            arrayList2.add(string);
        }
        double d = (double)arrayList.size() * drawHandler.textHeightMaxWithSpace() / 2.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = LineDescriptionUtils.replaceArrowsWithUtf8Characters((String)arrayList.get(i));
            object = LineDescriptionUtils.calcPosOfMiddleText(drawHandler, string, relationPointHandler.getMiddleLine(), i, d);
            int n = LineDescriptionEnum.MESSAGE_MIDDLE.getIndex() + i;
            this.printAndUpdateIndex(drawHandler, relationPointHandler, (PointDouble)object, n, string, hashSet);
        }
        for (String string : arrayList2) {
            object = LineDescriptionEnum.forString(string);
            String[] stringArray = string.split("=", -1);
            String string2 = stringArray[1];
            if (string2.isEmpty()) continue;
            PointDouble pointDouble = LineDescriptionUtils.calcPosOfEndText(drawHandler, string2, relationPointHandler, (LineDescriptionEnum)((Object)object));
            this.printAndUpdateIndex(drawHandler, relationPointHandler, pointDouble, ((LineDescriptionEnum)((Object)object)).getIndex(), string2, (Point)map.get(((LineDescriptionEnum)((Object)object)).getKey()), hashSet);
        }
        relationPointHandler.resetTextBoxIndexesExcept(hashSet);
        relationPointHandler.resizeRectAndReposPoints();
    }

    @Override
    public Priority getPriority() {
        return Priority.LOWEST;
    }
}

