/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.listener;

import com.baselet.control.Main;
import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.constants.Constants;
import com.baselet.control.constants.SystemInfo;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.PaletteHandler;
import com.baselet.diagram.SelectorFrame;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.element.Relation;
import com.baselet.element.sticking.StickableMap;
import com.baselet.element.sticking.Stickables;
import com.baselet.element.sticking.StickingPolygon;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.AddElement;
import com.baselet.gui.command.Command;
import com.baselet.gui.command.Macro;
import com.baselet.gui.command.Move;
import com.baselet.gui.command.MoveEnd;
import com.baselet.gui.command.OldMoveLinePoint;
import com.baselet.gui.command.OldRelationLinePoint;
import com.baselet.gui.command.OldResize;
import com.baselet.gui.listener.UniversalListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class GridElementListener
extends UniversalListener {
    private static final Logger log = Logger.getLogger(GridElementListener.class);
    protected boolean IS_DRAGGING = false;
    protected boolean IS_DRAGGING_DIAGRAM = false;
    protected boolean IS_DRAGGED_FROM_PALETTE = false;
    private boolean FIRST_DRAG = true;
    private Vector<Command> FIRST_MOVE_COMMANDS = null;
    private Point POINT_BEFORE_MOVE = null;
    protected boolean DESELECT_MULTISEL = false;
    private boolean LASSO_ACTIVE = false;
    private Rectangle lassoToleranceRectangle;
    private final int lassoTolerance = 2;
    private Point mousePressedPoint;
    private Set<Direction> resizeDirection;

    public GridElementListener(DiagramHandler handler) {
        super(handler);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        super.mouseDragged(me);
        log.debug((Object)"Entity dragged");
        GridElement e = this.getGridElement(me);
        if (this.LASSO_ACTIVE && this.lassoToleranceRectangle != null && !this.lassoToleranceRectangle.contains(this.getOffset(me))) {
            this.dragLasso(me, e);
            return;
        }
        if (this.disableElementMovement()) {
            return;
        }
        if (this.IS_DRAGGING_DIAGRAM) {
            this.dragDiagram();
        }
        if (this.IS_DRAGGING) {
            this.dragEntity(me.isShiftDown(), e);
        }
    }

    private GridElement getGridElement(MouseEvent me) {
        return this.handler.getDrawPanel().getElementToComponent(me.getComponent());
    }

    @Override
    protected Point getOffset(MouseEvent me) {
        return new Point(me.getX() + me.getComponent().getX(), me.getY() + me.getComponent().getY());
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        super.mouseMoved(me);
        GridElement e = this.getGridElement(me);
        if (this.IS_DRAGGED_FROM_PALETTE) {
            log.debug((Object)"mouseMoved with dragged");
            e.setLocation(me.getX() - 100, me.getY() - 20);
        }
        this.resizeDirection = e.getResizeArea(me.getX(), me.getY());
        Point point = new Point(me.getX() + e.getRectangle().getX(), me.getY() + e.getRectangle().getY());
        if (!e.isSelectableOn(point)) {
            CurrentGui.getInstance().getGui().setCursor(Constants.DEFAULT_CURSOR);
        } else if (this.resizeDirection.isEmpty()) {
            CurrentGui.getInstance().getGui().setCursor(Constants.HAND_CURSOR);
        } else if (this.resizeDirection.contains((Object)Direction.UP) && this.resizeDirection.contains((Object)Direction.RIGHT) || this.resizeDirection.contains((Object)Direction.DOWN) && this.resizeDirection.contains((Object)Direction.LEFT)) {
            CurrentGui.getInstance().getGui().setCursor(Constants.NE_CURSOR);
        } else if (this.resizeDirection.contains((Object)Direction.DOWN) && this.resizeDirection.contains((Object)Direction.RIGHT) || this.resizeDirection.contains((Object)Direction.UP) && this.resizeDirection.contains((Object)Direction.LEFT)) {
            CurrentGui.getInstance().getGui().setCursor(Constants.NW_CURSOR);
        } else if (this.resizeDirection.contains((Object)Direction.UP) || this.resizeDirection.contains((Object)Direction.DOWN)) {
            CurrentGui.getInstance().getGui().setCursor(Constants.TB_CURSOR);
        } else if (this.resizeDirection.contains((Object)Direction.LEFT) || this.resizeDirection.contains((Object)Direction.RIGHT)) {
            CurrentGui.getInstance().getGui().setCursor(Constants.LR_CURSOR);
        }
    }

    private void showContextMenu(GridElement ge, int x, int y) {
        if (!this.selector.getSelectedElements().contains(ge)) {
            this.selector.selectOnly(ge);
        }
        this.selector.setDominantEntity(ge);
        JPopupMenu contextMenu = CurrentGui.getInstance().getGui().getContextMenu(ge);
        if (contextMenu != null) {
            contextMenu.show((Component)((Object)ge.getComponent()), x, y);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        GridElement e = this.getGridElement(me);
        this.mousePressedPoint = this.getOffset(me);
        for (DiagramHandler h : Main.getInstance().getDiagramsAndPalettes()) {
            if (h.equals(this.handler)) continue;
            h.getDrawPanel().getSelector().deselectAllWithoutUpdatePropertyPanel();
        }
        if (me.getButton() == 3) {
            this.showContextMenu(e, me.getX(), me.getY());
        } else if (me.getButton() == 2) {
            this.IS_DRAGGING_DIAGRAM = true;
        } else if (me.getButton() == 1) {
            if (me.getClickCount() == 1) {
                this.pressedLeftButton(me);
            }
            if (me.getClickCount() == 2) {
                this.mouseDoubleClicked(e);
            }
        }
    }

    private void pressedLeftButton(MouseEvent me) {
        GridElement e = this.getGridElement(me);
        if ((me.getModifiers() & SystemInfo.META_KEY.getMask()) != 0) {
            this.initializeLasso();
        }
        this.IS_DRAGGING = true;
        if ((me.getModifiers() & SystemInfo.META_KEY.getMask()) != 0) {
            if (this.selector.isSelected(e)) {
                this.DESELECT_MULTISEL = true;
            } else {
                this.selector.select(e);
            }
        }
        if (!this.selector.getSelectedElements().contains(e)) {
            this.selector.selectOnly(e);
        } else {
            this.selector.updateSelectorInformation(e);
        }
    }

    public void mouseDoubleClicked(GridElement me) {
        GridElement e = ElementFactorySwing.createCopy(me);
        e.setProperty("group", null);
        GridElementListener eListener = this.handler.getEntityListener(e);
        int gridSize = CurrentDiagram.getInstance().getDiagramHandler().getGridSize();
        AddElement cmd = new AddElement(e, me.getRectangle().x + gridSize * 2, me.getRectangle().y + gridSize * 2);
        this.controller.executeCommand(cmd);
        this.selector.selectOnly(e);
        eListener.FIRST_DRAG = true;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        super.mouseReleased(me);
        if (this.IS_DRAGGED_FROM_PALETTE) {
            this.IS_DRAGGED_FROM_PALETTE = false;
        }
        GridElement e = this.getGridElement(me);
        if ((me.getModifiers() & SystemInfo.META_KEY.getMask()) != 0 && this.selector.isSelected(e) && this.DESELECT_MULTISEL) {
            this.selector.deselect(e);
        }
        if (this.IS_DRAGGING && !this.FIRST_DRAG) {
            this.controller.executeCommand(new MoveEnd(e));
        }
        this.DESELECT_MULTISEL = false;
        this.IS_DRAGGING = false;
        this.IS_DRAGGING_DIAGRAM = false;
        this.FIRST_DRAG = true;
        this.FIRST_MOVE_COMMANDS = null;
        this.POINT_BEFORE_MOVE = null;
        if (this.LASSO_ACTIVE) {
            this.LASSO_ACTIVE = false;
            ((JComponent)me.getComponent()).remove(this.selector.getSelectorFrame());
        }
    }

    private void initializeLasso() {
        this.lassoToleranceRectangle = new Rectangle(this.mousePressedPoint.x - 2, this.mousePressedPoint.y - 2, 4, 4);
        this.LASSO_ACTIVE = true;
        SelectorFrame selframe = this.selector.getSelectorFrame();
        selframe.setLocation(Converter.convert(this.mousePressedPoint));
        selframe.setSize(1, 1);
        CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().add((Component)selframe, 0);
        CurrentGui.getInstance().getGui().setCursor(Constants.DEFAULT_CURSOR);
    }

    private void dragLasso(MouseEvent me, GridElement e) {
        this.selector.setSelectorFrameActive(true);
        this.selector.getSelectorFrame().setDisplacement(e.getRectangle().x, e.getRectangle().y);
        this.selector.getSelectorFrame().resizeTo(me.getX(), me.getY());
        this.selector.deselectAll();
    }

    private void dragEntity(boolean isShiftKeyDown, GridElement mainElement) {
        this.DESELECT_MULTISEL = false;
        Point newp = this.getNewCoordinate();
        Point oldp = this.getOldCoordinate();
        int diffx = newp.x - oldp.x;
        int diffy = newp.y - oldp.y;
        List<GridElement> elementsToMove = this.selector.getSelectedElements();
        if (!this.resizeDirection.isEmpty()) {
            elementsToMove = Arrays.asList(mainElement);
        }
        if (this.FIRST_MOVE_COMMANDS == null) {
            this.POINT_BEFORE_MOVE = this.getOldCoordinateNotRounded();
            this.FIRST_MOVE_COMMANDS = GridElementListener.calculateFirstMoveCommands(diffx, diffy, oldp, elementsToMove, isShiftKeyDown, false, this.handler, this.resizeDirection);
        } else if (diffx != 0 || diffy != 0) {
            Vector<Command> commands = this.continueDragging(diffx, diffy, this.POINT_BEFORE_MOVE, elementsToMove);
            this.POINT_BEFORE_MOVE = new Point(this.POINT_BEFORE_MOVE.getX() + diffx, this.POINT_BEFORE_MOVE.getY() + diffy);
            this.controller.executeCommand(new Macro(commands));
            this.FIRST_DRAG = false;
        }
    }

    static Vector<Command> calculateFirstMoveCommands(int diffx, int diffy, Point oldp, Collection<GridElement> entitiesToBeMoved, boolean isShiftKeyDown, boolean useSetLocation, DiagramHandler handler, Set<Direction> directions) {
        Vector<Move> moveCommands = new Vector<Move>();
        Vector<OldMoveLinePoint> linepointCommands = new Vector<OldMoveLinePoint>();
        List<com.baselet.element.relation.Relation> stickables = handler.getDrawPanel().getStickables(entitiesToBeMoved);
        for (GridElement ge : entitiesToBeMoved) {
            StickableMap stickingStickables = Stickables.getStickingPointsWhichAreConnectedToStickingPolygon(ge.generateStickingBorder(), stickables);
            moveCommands.add(new Move(directions, ge, diffx, diffy, oldp, isShiftKeyDown, true, useSetLocation, stickingStickables));
            GridElementListener.handleStickingOfOldRelation(diffx, diffy, entitiesToBeMoved, handler, directions, linepointCommands, ge);
        }
        Vector<Command> allCommands = new Vector<Command>();
        allCommands.addAll(moveCommands);
        allCommands.addAll(linepointCommands);
        return allCommands;
    }

    @Deprecated
    private static void handleStickingOfOldRelation(int diffx, int diffy, Collection<GridElement> entitiesToBeMoved, DiagramHandler handler, Set<Direction> directions, Vector<OldMoveLinePoint> linepointCommands, GridElement ge) {
        StickingPolygon stick;
        boolean stickingDisabled;
        boolean bl = stickingDisabled = !SharedConfig.getInstance().isStickingEnabled() || handler instanceof PaletteHandler;
        if (!(ge instanceof Relation) && !stickingDisabled && (stick = ge.generateStickingBorder()) != null && directions.isEmpty()) {
            Vector<OldRelationLinePoint> affectedRelationPoints = OldResize.getStickingRelationLinePoints(handler, stick);
            int j = 0;
            while (j < affectedRelationPoints.size()) {
                OldRelationLinePoint tmpRlp = affectedRelationPoints.elementAt(j);
                if (!entitiesToBeMoved.contains(tmpRlp.getRelation())) {
                    linepointCommands.add(new OldMoveLinePoint(tmpRlp.getRelation(), tmpRlp.getLinePointId(), diffx, diffy));
                }
                ++j;
            }
        }
    }

    private Vector<Command> continueDragging(int diffx, int diffy, Point oldp, List<GridElement> elementsToMove) {
        boolean useSetLocation = elementsToMove.size() != 1;
        Vector<Command> tmpVector = new Vector<Command>();
        for (Command command : this.FIRST_MOVE_COMMANDS) {
            Command m;
            if (command instanceof Move) {
                m = (Move)command;
                tmpVector.add(new Move(this.resizeDirection, ((Move)m).getEntity(), diffx, diffy, oldp, ((Move)m).isShiftKeyDown(), this.FIRST_DRAG, useSetLocation, ((Move)m).getStickables()));
                continue;
            }
            if (!(command instanceof OldMoveLinePoint)) continue;
            m = (OldMoveLinePoint)command;
            tmpVector.add(new OldMoveLinePoint(((OldMoveLinePoint)m).getRelation(), ((OldMoveLinePoint)m).getLinePointId(), diffx, diffy));
        }
        return tmpVector;
    }
}

