/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.AddOnsTableModel;

public class InstalledAddOnsTableModel
extends AddOnsTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"", Constant.messages.getString("cfu.table.header.name"), Constant.messages.getString("cfu.table.header.desc"), Constant.messages.getString("cfu.table.header.update"), ""};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private static final Comparator<AddOnWrapper> COMPARATOR = new Comparator<AddOnWrapper>(){

        @Override
        public int compare(AddOnWrapper addOnWrapper, AddOnWrapper addOnWrapper2) {
            return addOnWrapper.getAddOn().getName().toLowerCase().compareTo(addOnWrapper2.getAddOn().getName().toLowerCase());
        }
    };
    private AddOnCollection availableAddOns;

    public InstalledAddOnsTableModel(AddOnCollection addOnCollection) {
        super(COMPARATOR, addOnCollection, 3);
        for (AddOn addOn : addOnCollection.getAddOns()) {
            this.addAddOnWrapper(addOn, null);
        }
    }

    public void setAvailableAddOns(AddOnCollection addOnCollection) {
        this.availableAddOns = addOnCollection;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return this.getAddOnWrappers().size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0 || n == 4) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        AddOnWrapper addOnWrapper = this.getAddOnWrapper(n);
        switch (n2) {
            case -1: {
                return addOnWrapper;
            }
            case 0: {
                return addOnWrapper.hasRunningIssues();
            }
            case 1: {
                return addOnWrapper.getAddOn().getName();
            }
            case 2: {
                return addOnWrapper.getAddOn().getDescription();
            }
            case 3: {
                int n3 = addOnWrapper.getProgress();
                if (addOnWrapper.isFailed()) {
                    return Constant.messages.getString("cfu.table.label.failed");
                }
                if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus()) {
                    return Constant.messages.getString("cfu.table.label.restartRequired");
                }
                if (n3 > 0) {
                    return n3 + "%";
                }
                if (AddOnWrapper.Status.newVersion == addOnWrapper.getStatus()) {
                    return Constant.messages.getString("cfu.table.label.update");
                }
                return "";
            }
            case 4: {
                return this.getAddOnWrapper(n).isEnabled();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 4) {
            return;
        }
        AddOnWrapper addOnWrapper = this.getAddOnWrapper(n);
        if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus()) {
            return;
        }
        if (object instanceof Boolean && addOnWrapper.getInstallationStatus() != AddOn.InstallationStatus.DOWNLOADING) {
            addOnWrapper.setEnabled((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 != 4) {
            return false;
        }
        AddOnWrapper addOnWrapper = this.getAddOnWrapper(n);
        if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus() || AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == addOnWrapper.getInstallationStatus()) {
            return false;
        }
        return addOnWrapper.getInstallationStatus() != AddOn.InstallationStatus.DOWNLOADING;
    }

    public boolean canUpdateSelected() {
        boolean bl = false;
        for (AddOnWrapper addOnWrapper : this.getAddOnWrappers()) {
            if (!addOnWrapper.isEnabled()) continue;
            if (AddOnWrapper.Status.newVersion == addOnWrapper.getStatus()) {
                bl = true;
                continue;
            }
            return false;
        }
        return bl;
    }

    public boolean canUninstallSelected() {
        boolean bl = false;
        for (AddOnWrapper addOnWrapper : this.getAddOnWrappers()) {
            if (!addOnWrapper.isEnabled()) continue;
            return true;
        }
        return bl;
    }

    public void addOrRefreshAddOn(AddOn addOn) {
        for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
            AddOnWrapper addOnWrapper = this.getAddOnWrappers().get(i);
            if (!addOn.isSameAddOn(this.getAddOnForDownload(addOnWrapper))) continue;
            addOnWrapper.setAddOn(addOn);
            this.fireTableRowsUpdated(i, i);
            this.refreshEntries();
            return;
        }
        this.addAddOnWrapper(addOn, null);
    }

    @Override
    protected boolean refreshEntry(AddOnWrapper addOnWrapper, int n) {
        boolean bl = super.refreshEntry(addOnWrapper, n);
        if (addOnWrapper.getAddOnUpdate() != null) {
            bl |= this.refreshUpdateIssues(addOnWrapper);
        }
        return bl;
    }

    @Override
    protected AddOnWrapper createAddOnWrapper(AddOn addOn, AddOnWrapper.Status status) {
        AddOn addOn2;
        AddOnWrapper addOnWrapper = super.createAddOnWrapper(addOn, status);
        if (this.availableAddOns != null && (addOn2 = this.availableAddOns.getAddOn(addOn.getId())) != null && addOn2.isUpdateTo(addOnWrapper.getAddOn())) {
            addOnWrapper.setAddOnUpdate(addOn2);
            this.refreshUpdateIssues(addOnWrapper);
        }
        return addOnWrapper;
    }

    private boolean refreshUpdateIssues(AddOnWrapper addOnWrapper) {
        AddOn.AddOnRunRequirements addOnRunRequirements = addOnWrapper.getAddOnUpdate().calculateRunRequirements(this.availableAddOns.getAddOns());
        String string = this.getAddOnRunningIssues(addOnRunRequirements);
        addOnWrapper.setUpdateIssues(string, !addOnRunRequirements.hasExtensionsWithRunningIssues());
        return !string.isEmpty();
    }

    public Set<AddOn> getSelectedUpdates() {
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        for (AddOnWrapper addOnWrapper : this.getAddOnWrappers()) {
            if (!addOnWrapper.isEnabled() || addOnWrapper.getAddOnUpdate() == null) continue;
            hashSet.add(addOnWrapper.getAddOnUpdate());
        }
        return hashSet;
    }

    @Override
    protected AddOn getAddOnForDownload(AddOnWrapper addOnWrapper) {
        if (addOnWrapper.getAddOnUpdate() == null) {
            return addOnWrapper.getAddOn();
        }
        return addOnWrapper.getAddOnUpdate();
    }

    public List<AddOn> updateEntries() {
        if (this.availableAddOns == null) {
            return Collections.emptyList();
        }
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>(this.availableAddOns.getAddOns());
        for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
            boolean bl = false;
            boolean bl2 = false;
            AddOnWrapper addOnWrapper = this.getAddOnWrappers().get(i);
            InstalledAddOnsTableModel.removeAddOn(arrayList, addOnWrapper.getAddOn().getId());
            AddOn addOn = this.availableAddOns.getAddOn(addOnWrapper.getAddOn().getId());
            if (addOn != null && addOn.isUpdateTo(addOnWrapper.getAddOn())) {
                addOnWrapper.setAddOnUpdate(addOn);
                this.refreshUpdateIssues(addOnWrapper);
                bl = true;
            } else {
                addOnWrapper.setStatus(null);
                bl2 = true;
            }
            if (addOnWrapper.hasRunningIssues()) {
                bl = this.refreshRunningIssues(addOnWrapper, i);
            }
            if (bl) {
                this.fireTableRowsUpdated(i, i);
                continue;
            }
            if (!bl2) continue;
            this.fireTableCellUpdated(i, 3);
        }
        return arrayList;
    }

    public static void removeAddOn(List<AddOn> list, String string) {
        Iterator<AddOn> iterator = list.iterator();
        while (iterator.hasNext()) {
            AddOn addOn = iterator.next();
            if (!addOn.getId().equals(string)) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    protected void restoreInstallationStatusFailedDownload(AddOnWrapper addOnWrapper) {
        addOnWrapper.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
    }

    @Override
    protected AddOn getMissingAddOn(String string) {
        AddOn addOn = super.getMissingAddOn(string);
        if (addOn != null) {
            return addOn;
        }
        if (this.availableAddOns != null) {
            return this.availableAddOns.getAddOn(string);
        }
        return null;
    }
}

