/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.configuration.ConfigurationException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class ContextExportDialog
extends StandardFieldsDialog {
    private static final long serialVersionUID = 1L;
    private static final String CONTEXT_FIELD = "context.import.label.context";
    private static final String DIR_FIELD = "context.import.label.dir";
    private static final String FILE_FIELD = "context.import.label.file";
    private static final String OVERWRITE_FIELD = "context.import.label.overwrite";
    private static final String CONTEXT_EXT = ".context";

    public ContextExportDialog(Frame frame) {
        super(frame, "context.import.title", new Dimension(400, 250));
        this.addContextSelectField(CONTEXT_FIELD, null);
        this.addFileSelectField(DIR_FIELD, Constant.getContextsDir(), 1, null);
        this.addTextField(FILE_FIELD, null);
        this.addCheckBoxField(OVERWRITE_FIELD, false);
        super.addFieldListener(CONTEXT_FIELD, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Context context = ContextExportDialog.this.getContextValue(ContextExportDialog.CONTEXT_FIELD);
                if (context != null) {
                    String string = context.getName() + ContextExportDialog.CONTEXT_EXT;
                    ContextExportDialog.this.setFieldValue(ContextExportDialog.FILE_FIELD, string);
                }
            }
        });
    }

    private File getSelectedFile() {
        if (this.isEmptyField(DIR_FIELD) || this.isEmptyField(FILE_FIELD)) {
            return null;
        }
        return new File(this.getStringValue(DIR_FIELD), this.getStringValue(FILE_FIELD));
    }

    @Override
    public void save() {
        try {
            Model.getSingleton().getSession().exportContext(this.getContextValue(CONTEXT_FIELD), this.getSelectedFile());
        }
        catch (ConfigurationException configurationException) {
            View.getSingleton().showWarningDialog(this, MessageFormat.format(Constant.messages.getString("context.import.error"), configurationException.getMessage()));
        }
    }

    @Override
    public String validateFields() {
        File file = this.getSelectedFile();
        if (this.getContextValue(CONTEXT_FIELD) == null) {
            return Constant.messages.getString("context.import.error.nocontext");
        }
        if (file == null) {
            return Constant.messages.getString("context.import.error.nofile");
        }
        if (file.exists() & this.getBoolValue(OVERWRITE_FIELD) == false) {
            return Constant.messages.getString("context.import.error.exists");
        }
        if (!file.getParentFile().canWrite()) {
            return Constant.messages.getString("context.import.error.noaccess");
        }
        return null;
    }
}

