/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.MainFrame;
import org.parosproxy.paros.view.TabbedPanel;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.MainToolbarPanel;

public class MessagePanelsPositionController {
    private static final String TABS_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.tabs");
    private static final String ABOVE_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.above");
    private static final String SIDE_BY_SIDE_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.sideBySide");
    private static final String BASE_KEY = "view.messagePanelsPosition.";
    private static final String LAST_POSITION_CONFIG_KEY = "view.messagePanelsPosition.lastSelectedPosition";
    private HttpPanelRequest requestPanel;
    private HttpPanelResponse responsePanel;
    private WorkbenchPanel workbenchPanel;
    private TabbedPanel tabbedWork;
    private JToggleButton tabsButtonView;
    private JToggleButton aboveButtonView;
    private JToggleButton sideBySideButtonView;
    private TabbedPanel splitTabbedPanel;
    private MessagePanelsPosition currentPosition;

    public MessagePanelsPositionController(HttpPanelRequest httpPanelRequest, HttpPanelResponse httpPanelResponse, MainFrame mainFrame, WorkbenchPanel workbenchPanel) {
        this.requestPanel = httpPanelRequest;
        this.responsePanel = httpPanelResponse;
        this.workbenchPanel = workbenchPanel;
        this.tabbedWork = workbenchPanel.getTabbedWork();
        this.currentPosition = MessagePanelsPosition.TABS_SIDE_BY_SIDE;
        this.tabsButtonView = new JToggleButton(new ChangeMessagePanelsPositionAction(MessagePanelsPositionController.class.getResource("/resource/icon/layout_tabbed.png"), MessagePanelsPosition.TABS_SIDE_BY_SIDE));
        this.tabsButtonView.setToolTipText(TABS_VIEW_TOOL_TIP);
        this.aboveButtonView = new JToggleButton(new ChangeMessagePanelsPositionAction(MessagePanelsPositionController.class.getResource("/resource/icon/layout_vertical_split.png"), MessagePanelsPosition.PANEL_ABOVE));
        this.aboveButtonView.setToolTipText(ABOVE_VIEW_TOOL_TIP);
        this.sideBySideButtonView = new JToggleButton(new ChangeMessagePanelsPositionAction(MessagePanelsPositionController.class.getResource("/resource/icon/layout_horizontal_split.png"), MessagePanelsPosition.PANELS_SIDE_BY_SIDE));
        this.sideBySideButtonView.setToolTipText(SIDE_BY_SIDE_VIEW_TOOL_TIP);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.tabsButtonView);
        buttonGroup.add(this.aboveButtonView);
        buttonGroup.add(this.sideBySideButtonView);
        this.tabsButtonView.setSelected(true);
        MainToolbarPanel mainToolbarPanel = mainFrame.getMainToolbarPanel();
        mainToolbarPanel.addButton(this.tabsButtonView);
        mainToolbarPanel.addButton(this.aboveButtonView);
        mainToolbarPanel.addButton(this.sideBySideButtonView);
        mainToolbarPanel.addSeparator();
        this.splitTabbedPanel = new TabbedPanel();
        this.splitTabbedPanel.setAlternativeParent(mainFrame.getPaneDisplay());
        this.splitTabbedPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    private void changeMessageTabsPosition(MessagePanelsPosition messagePanelsPosition) {
        this.currentPosition = messagePanelsPosition;
        this.saveState(messagePanelsPosition);
        if (View.getDisplayOption() == 2) {
            return;
        }
        TabbedPanel tabbedPanel = this.restoreOriginalParentTabbedPanel();
        switch (messagePanelsPosition) {
            case PANEL_ABOVE: {
                this.splitResponsePanelWithWorkTabbedPanel(0);
                break;
            }
            case PANELS_SIDE_BY_SIDE: {
                this.splitResponsePanelWithWorkTabbedPanel(1);
                break;
            }
            default: {
                if (tabbedPanel == this.splitTabbedPanel) {
                    tabbedPanel = this.tabbedWork;
                }
                boolean bl = Model.getSingleton().getOptionsParam().getViewParam().getShowTabNames();
                String string = this.responsePanel.getName();
                if (!bl) {
                    string = "";
                }
                this.tabbedWork.insertTab(string, DisplayUtils.getScaledIcon(this.responsePanel.getIcon()), this.responsePanel, null, this.tabbedWork.indexOfComponent(this.requestPanel) + 1);
                this.workbenchPanel.removeSplitPaneWork();
            }
        }
        this.restoreAlternativeParentTabbedPanel(tabbedPanel);
    }

    private void splitResponsePanelWithWorkTabbedPanel(int n) {
        this.splitTabbedPanel.removeAll();
        boolean bl = Model.getSingleton().getOptionsParam().getViewParam().getShowTabNames();
        if (bl) {
            this.splitTabbedPanel.addTab(this.responsePanel.getName(), DisplayUtils.getScaledIcon(this.responsePanel.getIcon()), this.responsePanel);
        } else {
            this.splitTabbedPanel.addTab("", DisplayUtils.getScaledIcon(this.responsePanel.getIcon()), this.responsePanel);
        }
        this.workbenchPanel.splitPaneWorkWithTabbedPanel(this.splitTabbedPanel, n);
    }

    public TabbedPanel restoreOriginalParentTabbedPanel() {
        if (this.tabbedWork.isInAlternativeParent()) {
            this.tabbedWork.alternateParent();
            return this.tabbedWork;
        }
        if (this.splitTabbedPanel.isInAlternativeParent()) {
            this.splitTabbedPanel.alternateParent();
            return this.splitTabbedPanel;
        }
        return null;
    }

    private void restoreAlternativeParentTabbedPanel(TabbedPanel tabbedPanel) {
        if (tabbedPanel != null) {
            tabbedPanel.alternateParent();
        }
    }

    public void restoreState() {
        FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
        MessagePanelsPosition messagePanelsPosition = MessagePanelsPosition.valueOf(fileConfiguration.getString(LAST_POSITION_CONFIG_KEY, MessagePanelsPosition.TABS_SIDE_BY_SIDE.toString()));
        this.changeMessageTabsPosition(messagePanelsPosition);
        switch (messagePanelsPosition) {
            case PANEL_ABOVE: {
                this.aboveButtonView.setSelected(true);
                break;
            }
            case PANELS_SIDE_BY_SIDE: {
                this.sideBySideButtonView.setSelected(true);
                break;
            }
            default: {
                this.tabsButtonView.setSelected(true);
            }
        }
    }

    public void saveState(MessagePanelsPosition messagePanelsPosition) {
        FileConfiguration fileConfiguration = Model.getSingleton().getOptionsParam().getConfig();
        fileConfiguration.setProperty(LAST_POSITION_CONFIG_KEY, (Object)messagePanelsPosition.toString());
    }

    private final class ChangeMessagePanelsPositionAction
    extends AbstractAction {
        private static final long serialVersionUID = 756133292459364854L;
        private final MessagePanelsPosition position;

        public ChangeMessagePanelsPositionAction(URL uRL, MessagePanelsPosition messagePanelsPosition) {
            super("", new ImageIcon(uRL));
            this.position = messagePanelsPosition;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MessagePanelsPositionController.this.changeMessageTabsPosition(this.position);
        }
    }

    private static enum MessagePanelsPosition {
        TABS_SIDE_BY_SIDE,
        PANEL_ABOVE,
        PANELS_SIDE_BY_SIDE;

    }
}

