/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.InternalMethod;

@NodeChildren(value={@NodeChild(value="method"), @NodeChild(value="module")})
public abstract class CanBindMethodToModuleNode
extends RubyNode {
    public CanBindMethodToModuleNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract boolean executeCanBindMethodToModule(InternalMethod var1, DynamicObject var2);

    @Specialization(guards={"isRubyModule(module)", "method.getDeclaringModule() == declaringModule", "module == cachedModule"}, limit="getCacheLimit()")
    protected boolean canBindMethodToCached(InternalMethod method, DynamicObject module, @Cached(value="method.getDeclaringModule()") DynamicObject declaringModule, @Cached(value="module") DynamicObject cachedModule, @Cached(value="canBindMethodTo(declaringModule, cachedModule)") boolean canBindMethodTo) {
        return canBindMethodTo;
    }

    @Specialization(guards={"isRubyModule(module)"})
    protected boolean canBindMethodToUncached(InternalMethod method, DynamicObject module) {
        DynamicObject declaringModule = method.getDeclaringModule();
        return this.canBindMethodTo(declaringModule, module);
    }

    protected boolean canBindMethodTo(DynamicObject declaringModule, DynamicObject module) {
        return ModuleOperations.canBindMethodTo(declaringModule, module);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().BIND_CACHE;
    }
}

