/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class MissingALACAttributePanel
extends SecurityDialogPanel {
    public MissingALACAttributePanel(SecurityDialog x, String title, String codebase, String remoteUrls) {
        super(x);
        try {
            this.addComponents(title, codebase, remoteUrls);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (x != null) {
            x.setMinimumSize(new Dimension(600, 400));
        }
    }

    protected final void addComponents(String title, String codebase, String remoteUrls) throws IOException {
        URL imgUrl = this.getClass().getResource("/net/sourceforge/jnlp/resources/warning.png");
        BufferedImage img = ImageIO.read(imgUrl);
        ImageIcon icon = new ImageIcon(img);
        String topLabelText = Translator.R("ALACAMissingMainTitle", title, codebase, remoteUrls);
        String bottomLabelText = Translator.R("ALACAMissingInfo");
        JLabel topLabel = new JLabel(this.htmlWrap(topLabelText), icon, 0);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(400, 80));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JEditorPane bottomLabel = new JEditorPane("text/html", this.htmlWrap(bottomLabelText));
        bottomLabel.setEditable(false);
        bottomLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                }
                catch (IOException ex) {
                    OutputController.getLogger().log(ex);
                }
                catch (URISyntaxException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        });
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)bottomLabel, "Center");
        infoPanel.setPreferredSize(new Dimension(400, 80));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        bottomLabel.setBackground(infoPanel.getBackground());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton yes = new JButton(Translator.R("ButYes"));
        JButton no = new JButton(Translator.R("ButNo"));
        yes.addActionListener(this.createSetValueListener(this.parent, 0));
        no.addActionListener(this.createSetValueListener(this.parent, 1));
        this.initialFocusComponent = no;
        buttonPanel.add(yes);
        buttonPanel.add(no);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(topPanel);
        this.add(infoPanel);
        this.add(buttonPanel);
    }

    public static void main(String[] args) throws MalformedURLException {
        HashSet<URL> s = new HashSet<URL>();
        s.add(new URL("http:/blah.com/blah"));
        s.add(new URL("http:/blah.com/blah/blah"));
        MissingALACAttributePanel w = new MissingALACAttributePanel(null, "HelloWorld", "http://nbblah.url", UrlUtils.setOfUrlsToHtmlList(s));
        JFrame f = new JFrame();
        f.setSize(600, 400);
        f.add((Component)w, "Center");
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

