/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.config.BasicValueValidators;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityLevel;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletStartupSecuritySettings;
import net.sourceforge.jnlp.util.ClasspathMatcher;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ManifestAttributesChecker {
    private final SecurityDesc security;
    private final JNLPFile file;
    private final JNLPClassLoader.SigningState signing;
    private final JNLPClassLoader.SecurityDelegate securityDelegate;

    public ManifestAttributesChecker(SecurityDesc security, JNLPFile file, JNLPClassLoader.SigningState signing, JNLPClassLoader.SecurityDelegate securityDelegate) throws LaunchException {
        this.security = security;
        this.file = file;
        this.signing = signing;
        this.securityDelegate = securityDelegate;
    }

    void checkAll() throws LaunchException {
        List<MANIFEST_ATTRIBUTES_CHECK> attributesCheck = ManifestAttributesChecker.getAttributesCheck();
        if (attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.NONE)) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("MACDisabledMessage"));
        } else {
            if (attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.TRUSTED) || attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.ALL)) {
                this.checkTrustedOnlyAttribute();
            } else {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("MACCheckSkipped", "Trusted-Only", "TRUSTED"));
            }
            if (attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.CODEBASE) || attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.ALL)) {
                this.checkCodebaseAttribute();
            } else {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("MACCheckSkipped", "Codebase", "CODEBASE"));
            }
            if (attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.PERMISSIONS) || attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.ALL)) {
                this.checkPermissionsAttribute();
            } else {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("MACCheckSkipped", "Permissions", "PERMISSIONS"));
            }
            if (attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.ALAC) || attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.ALL)) {
                this.checkApplicationLibraryAllowableCodebaseAttribute();
            } else {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("MACCheckSkipped", "Application Library Allowable Codebase", "ALAC"));
            }
            if (attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.ENTRYPOINT) || attributesCheck.contains((Object)MANIFEST_ATTRIBUTES_CHECK.ALL)) {
                this.checkEntryPoint();
            } else {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("MACCheckSkipped", "Entry-Point", "ENTRYPOINT"));
            }
        }
    }

    public static List<MANIFEST_ATTRIBUTES_CHECK> getAttributesCheck() {
        String deploymentProperty = JNLPRuntime.getConfiguration().getProperty("deployment.manifest.attributes.check");
        String[] attributesCheck = BasicValueValidators.splitCombination(deploymentProperty);
        ArrayList<MANIFEST_ATTRIBUTES_CHECK> manifestAttributesCheckList = new ArrayList<MANIFEST_ATTRIBUTES_CHECK>();
        for (String attribute : attributesCheck) {
            for (MANIFEST_ATTRIBUTES_CHECK manifestAttribute : MANIFEST_ATTRIBUTES_CHECK.values()) {
                if (!manifestAttribute.toString().equals(attribute)) continue;
                manifestAttributesCheckList.add(manifestAttribute);
            }
        }
        return manifestAttributesCheckList;
    }

    private void checkEntryPoint() throws LaunchException {
        if (this.signing == JNLPClassLoader.SigningState.NONE) {
            return;
        }
        if (this.file.getLaunchInfo() == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Entry-Point can not be checked now, because of not existing launch info.");
            return;
        }
        if (this.file.getLaunchInfo().getMainClass() == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Entry-Point can not be checked now, because of unknown main class.");
            return;
        }
        String[] eps = this.file.getManifestsAttributes().getEntryPoints();
        String mainClass = this.file.getLaunchInfo().getMainClass();
        if (eps == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Entry-Point manifest attribute for yours '" + mainClass + "'not found. Continuing.");
            return;
        }
        for (String ep : eps) {
            if (!ep.equals(mainClass)) continue;
            OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Entry-Point of " + ep + " mathches " + mainClass + " continuing.");
            return;
        }
        throw new LaunchException("None of the entry points specified: '" + this.file.getManifestsAttributes().getEntryPointString() + "' matched the main class " + mainClass + " and apelt is signed. This is a security error and the app will not be launched.");
    }

    private void checkTrustedOnlyAttribute() throws LaunchException {
        boolean requestsCorrectPermissions;
        JNLPFile.ManifestBoolean trustedOnly = this.file.getManifestsAttributes().isTrustedOnly();
        if (trustedOnly == JNLPFile.ManifestBoolean.UNDEFINED) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Trusted Only manifest attribute not found. Continuing.");
            return;
        }
        if (trustedOnly == JNLPFile.ManifestBoolean.FALSE) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Trusted Only manifest attribute is false. Continuing.");
            return;
        }
        Object desc = this.security.getSecurityType();
        String securityType = desc == null ? "Not Specified" : (desc.equals(SecurityDesc.ALL_PERMISSIONS) ? "All-Permission" : (desc.equals(SecurityDesc.SANDBOX_PERMISSIONS) ? "Sandbox" : (desc.equals(SecurityDesc.J2EE_PERMISSIONS) ? "J2EE" : "Unknown")));
        boolean isFullySigned = this.signing == JNLPClassLoader.SigningState.FULL;
        boolean isSandboxed = this.securityDelegate.getRunInSandbox();
        boolean bl = requestsCorrectPermissions = isFullySigned && SecurityDesc.ALL_PERMISSIONS.equals(desc) || isSandboxed && SecurityDesc.SANDBOX_PERMISSIONS.equals(desc);
        String signedMsg = isFullySigned && !isSandboxed ? Translator.R("STOAsignedMsgFully") : (isFullySigned && isSandboxed ? Translator.R("STOAsignedMsgAndSandbox") : Translator.R("STOAsignedMsgPartiall"));
        OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Trusted Only manifest attribute is \"true\". " + signedMsg + " and requests permission level: " + securityType);
        if (!isFullySigned || !requestsCorrectPermissions) {
            throw new LaunchException(Translator.R("STrustedOnlyAttributeFailure", signedMsg, securityType));
        }
    }

    private void checkCodebaseAttribute() throws LaunchException {
        if (this.file.getCodeBase() == null || this.file.getCodeBase().getProtocol().equals("file")) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("CBCheckFile"));
            return;
        }
        Object securityType = this.security.getSecurityType();
        URL codebase = UrlUtils.guessCodeBase(this.file);
        ClasspathMatcher.ClasspathMatchers codebaseAtt = this.file.getManifestsAttributes().getCodebase();
        if (codebaseAtt == null) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("CBCheckNoEntry"));
            return;
        }
        if (securityType.equals(SecurityDesc.SANDBOX_PERMISSIONS)) {
            if (codebaseAtt.matches(codebase)) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CBCheckUnsignedPass"));
            } else {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("CBCheckUnsignedFail"));
            }
        } else if (codebaseAtt.matches(codebase)) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CBCheckOkSignedOk"));
        } else {
            if (this.file instanceof PluginBridge) {
                throw new LaunchException(Translator.R("CBCheckSignedAppletDontMatchException", this.file.getManifestsAttributes().getCodebase().toString(), codebase));
            }
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, Translator.R("CBCheckSignedFail"));
        }
    }

    private void checkPermissionsAttribute() throws LaunchException {
        if (this.securityDelegate.getRunInSandbox()) {
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "The 'Permissions' attribute of this application is '" + this.file.getManifestsAttributes().permissionsToString() + "'. You have chosen the Sandbox run option, which overrides the Permissions manifest attribute, or the applet has already been automatically sandboxed.");
            return;
        }
        JNLPFile.ManifestBoolean sandboxForced = this.file.getManifestsAttributes().isSandboxForced();
        if (sandboxForced == JNLPFile.ManifestBoolean.UNDEFINED) {
            AppletSecurityLevel itwSecurityLevel = AppletStartupSecuritySettings.getInstance().getSecurityLevel();
            if (itwSecurityLevel == AppletSecurityLevel.DENY_UNSIGNED) {
                throw new LaunchException("Your Extended applets security is at 'Very high', and this application is missing the 'permissions' attribute in manifest. This is fatal");
            }
            if (itwSecurityLevel == AppletSecurityLevel.ASK_UNSIGNED) {
                boolean userApproved = SecurityDialogs.showMissingPermissionsAttributeDialogue(this.file.getTitle(), this.file.getCodeBase());
                if (!userApproved) {
                    throw new LaunchException("Your Extended applets security is at 'high' and this application is missing the 'permissions' attribute in manifest. And you have refused to run it.");
                }
                OutputController.getLogger().log("Your Extended applets security is at 'high' and this application is missing the 'permissions' attribute in manifest. And you have allowed to run it.");
            }
            return;
        }
        SecurityDesc.RequestedPermissionLevel requestedPermissions = this.file.getRequestedPermissionLevel();
        this.validateRequestedPermissionLevelMatchesManifestPermissions(requestedPermissions, sandboxForced);
        if (this.file instanceof PluginBridge) {
            if (ManifestAttributesChecker.isNoneOrDefault(requestedPermissions) && sandboxForced == JNLPFile.ManifestBoolean.TRUE && this.signing != JNLPClassLoader.SigningState.NONE) {
                this.securityDelegate.setRunInSandbox();
            }
        } else if (ManifestAttributesChecker.isNoneOrDefault(requestedPermissions)) {
            if (sandboxForced == JNLPFile.ManifestBoolean.TRUE && this.signing != JNLPClassLoader.SigningState.NONE) {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "The 'permissions' attribute is '" + this.file.getManifestsAttributes().permissionsToString() + "' and the applet is signed. Forcing sandbox.");
                this.securityDelegate.setRunInSandbox();
            }
            if (sandboxForced == JNLPFile.ManifestBoolean.FALSE && this.signing == JNLPClassLoader.SigningState.NONE) {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "The 'permissions' attribute is '" + this.file.getManifestsAttributes().permissionsToString() + "' and the applet is unsigned. Forcing sandbox.");
                this.securityDelegate.setRunInSandbox();
            }
        }
    }

    private static boolean isLowSecurity() {
        return AppletStartupSecuritySettings.getInstance().getSecurityLevel().equals((Object)AppletSecurityLevel.ALLOW_UNSIGNED);
    }

    private static boolean isNoneOrDefault(SecurityDesc.RequestedPermissionLevel requested) {
        return requested == SecurityDesc.RequestedPermissionLevel.NONE || requested == SecurityDesc.RequestedPermissionLevel.DEFAULT;
    }

    private void validateRequestedPermissionLevelMatchesManifestPermissions(SecurityDesc.RequestedPermissionLevel requested, JNLPFile.ManifestBoolean sandboxForced) throws LaunchException {
        if (requested == SecurityDesc.RequestedPermissionLevel.ALL && sandboxForced != JNLPFile.ManifestBoolean.FALSE) {
            throw new LaunchException("The 'permissions' attribute is '" + this.file.getManifestsAttributes().permissionsToString() + "' but the applet requested " + (Object)((Object)requested) + ". This is fatal");
        }
        if (requested == SecurityDesc.RequestedPermissionLevel.SANDBOX && sandboxForced != JNLPFile.ManifestBoolean.TRUE) {
            throw new LaunchException("The 'permissions' attribute is '" + this.file.getManifestsAttributes().permissionsToString() + "' but the applet requested " + (Object)((Object)requested) + ". This is fatal");
        }
    }

    private void checkApplicationLibraryAllowableCodebaseAttribute() throws LaunchException {
        boolean userApproved;
        URL codebase = this.file.getCodeBase();
        URL documentBase = null;
        if (this.file instanceof PluginBridge) {
            documentBase = ((PluginBridge)this.file).getSourceLocation();
        }
        if (documentBase == null) {
            documentBase = this.file.getCodeBase();
        }
        HashSet<URL> usedUrls = new HashSet<URL>();
        URL sourceLocation = this.file.getSourceLocation();
        ResourcesDesc[] resourcesDescs = this.file.getResourcesDescs();
        if (sourceLocation != null) {
            usedUrls.add(UrlUtils.removeFileName(sourceLocation));
        }
        for (ResourcesDesc resourcesDesc : resourcesDescs) {
            JNLPFile jnlp;
            JARDesc[] jars;
            ExtensionDesc[] ex = resourcesDesc.getExtensions();
            if (ex != null) {
                for (ExtensionDesc extensionDesc : ex) {
                    if (extensionDesc == null) continue;
                    usedUrls.add(UrlUtils.removeFileName(extensionDesc.getLocation()));
                }
            }
            if ((jars = resourcesDesc.getJARs()) != null) {
                for (JARDesc jarDesc : jars) {
                    if (jarDesc == null) continue;
                    usedUrls.add(UrlUtils.removeFileName(jarDesc.getLocation()));
                }
            }
            if ((jnlp = resourcesDesc.getJNLPFile()) == null) continue;
            usedUrls.add(UrlUtils.removeFileName(jnlp.getSourceLocation()));
        }
        OutputController.getLogger().log("Found alaca URLs to be verified");
        for (URL url : usedUrls) {
            OutputController.getLogger().log(" - " + url.toExternalForm());
        }
        if (usedUrls.isEmpty()) {
            OutputController.getLogger().log("The application is not using any url resources, skipping Application-Library-Allowable-Codebase Attribute check.");
            return;
        }
        boolean allOk = true;
        for (URL u : usedUrls) {
            if (UrlUtils.equalsIgnoreLastSlash(u, codebase) && UrlUtils.equalsIgnoreLastSlash(u, ManifestAttributesChecker.stripDocbase(documentBase))) {
                OutputController.getLogger().log("OK - " + u.toExternalForm() + " is from codebase/docbase.");
                continue;
            }
            allOk = false;
            OutputController.getLogger().log("Warning! " + u.toExternalForm() + " is NOT from codebase/docbase.");
        }
        if (allOk) {
            OutputController.getLogger().log("All applications resources (" + usedUrls.toArray(new URL[0])[0] + ") are from codebas/documentbase " + codebase + "/" + documentBase + ", skipping Application-Library-Allowable-Codebase Attribute check.");
            return;
        }
        ClasspathMatcher.ClasspathMatchers att = null;
        if (this.signing != JNLPClassLoader.SigningState.NONE) {
            att = this.file.getManifestsAttributes().getApplicationLibraryAllowableCodebase();
        }
        if (att == null) {
            boolean userApproved2 = SecurityDialogs.showMissingALACAttributePanel(this.file.getTitle(), documentBase, usedUrls);
            if (!userApproved2) {
                throw new LaunchException("The application uses non-codebase resources, has no Application-Library-Allowable-Codebase Attribute, and was blocked from running by the user");
            }
            OutputController.getLogger().log("The application uses non-codebase resources, has no Application-Library-Allowable-Codebase Attribute, and was allowed to run by the user or user's security settings");
            return;
        }
        for (URL foundUrl : usedUrls) {
            if (!att.matches(foundUrl)) {
                throw new LaunchException("The resource from " + foundUrl + " does not match the  location in Application-Library-Allowable-Codebase Attribute " + att + ". Blocking the application from running.");
            }
            OutputController.getLogger().log("The resource from " + foundUrl + " does  match the  location in Application-Library-Allowable-Codebase Attribute " + att + ". Continuing.");
        }
        boolean bl = userApproved = ManifestAttributesChecker.isLowSecurity() || SecurityDialogs.showMatchingALACAttributePanel(this.file, documentBase, usedUrls);
        if (!userApproved) {
            throw new LaunchException("The application uses non-codebase resources, which do match its Application-Library-Allowable-Codebase Attribute, but was blocked from running by the user.");
        }
        OutputController.getLogger().log("The application uses non-codebase resources, which do match its Application-Library-Allowable-Codebase Attribute, and was allowed to run by the user or user's security settings.");
    }

    static URL stripDocbase(URL documentBase) {
        int i2;
        String s = documentBase.toExternalForm();
        if (s.endsWith("/") || s.endsWith("\\")) {
            return documentBase;
        }
        int i1 = s.lastIndexOf("/");
        int i = Math.max(i1, i2 = s.lastIndexOf("\\"));
        if (i <= 8 || i >= s.length()) {
            return documentBase;
        }
        s = s.substring(0, i + 1);
        try {
            documentBase = new URL(s);
        }
        catch (MalformedURLException ex) {
            OutputController.getLogger().log(ex);
        }
        return documentBase;
    }

    public static enum MANIFEST_ATTRIBUTES_CHECK {
        ALL,
        NONE,
        PERMISSIONS,
        CODEBASE,
        TRUSTED,
        ALAC,
        ENTRYPOINT;

    }
}

