/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro.version4;

import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPBend;
import dguitar.codecs.guitarPro.GPBendPoint;
import dguitar.codecs.guitarPro.GPBendType;
import dguitar.codecs.guitarPro.GPChordDiagram;
import dguitar.codecs.guitarPro.GPChordNote;
import dguitar.codecs.guitarPro.GPChordType;
import dguitar.codecs.guitarPro.GPColor;
import dguitar.codecs.guitarPro.GPDuration;
import dguitar.codecs.guitarPro.GPDynamic;
import dguitar.codecs.guitarPro.GPEffectsOnBeat;
import dguitar.codecs.guitarPro.GPEffectsOnNote;
import dguitar.codecs.guitarPro.GPFingering;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPGraceNote;
import dguitar.codecs.guitarPro.GPGraceNoteTransition;
import dguitar.codecs.guitarPro.GPHarmonic;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPKey;
import dguitar.codecs.guitarPro.GPMIDIChannel;
import dguitar.codecs.guitarPro.GPMarker;
import dguitar.codecs.guitarPro.GPMeasure;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPMixTableChange;
import dguitar.codecs.guitarPro.GPMixTableElement;
import dguitar.codecs.guitarPro.GPNote;
import dguitar.codecs.guitarPro.GPPickStroke;
import dguitar.codecs.guitarPro.GPSlide;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.GPTonalityType;
import dguitar.codecs.guitarPro.GPTrack;
import dguitar.codecs.guitarPro.GPTrackLyrics;
import dguitar.codecs.guitarPro.GPTrill;
import dguitar.codecs.guitarPro.GPVibrato;
import dguitar.codecs.guitarPro.version4.GP4FormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class GP4InputStream
extends GPInputStream {
    private static final String[] supportedVersions = new String[]{"FICHIER GUITAR PRO v4.00", "FICHIER GUITAR PRO v4.06", "FICHIER GUITAR PRO L4.06"};

    public GP4InputStream(InputStream in) {
        super(in);
    }

    public GP4InputStream(GPInputStream gpIn) {
        super(gpIn);
    }

    public static boolean supportedVersion(String version) {
        boolean correct = false;
        int i = 0;
        while (i < supportedVersions.length && !correct) {
            correct = version.equals(supportedVersions[i]);
            ++i;
        }
        return correct;
    }

    public static String supportedVersions() {
        String s = "";
        int i = 0;
        while (i < supportedVersions.length) {
            s = String.valueOf(s) + supportedVersions[i];
            if (i + 1 < supportedVersions.length) {
                s = String.valueOf(s) + "\n";
            }
            ++i;
        }
        return s;
    }

    public GPSong readPiece() throws IOException, GPFormatException {
        GPSong piece = new GPSong();
        if (this.__version.equals("")) {
            this.__version = this.readStringByte(30);
        }
        piece.setVersion(this.__version);
        String s = this.readStringIntegerPlusOne();
        piece.setTitle(s);
        s = this.readStringIntegerPlusOne();
        piece.setSubtitle(s);
        s = this.readStringIntegerPlusOne();
        piece.setInterpret(s);
        s = this.readStringIntegerPlusOne();
        piece.setAlbum(s);
        s = this.readStringIntegerPlusOne();
        piece.setAuthorSong(s);
        s = this.readStringIntegerPlusOne();
        piece.setCopyright(s);
        s = this.readStringIntegerPlusOne();
        piece.setAuthorPiece(s);
        s = this.readStringIntegerPlusOne();
        piece.setInstruction(s);
        int nbNotes = this.readInt();
        String note = "";
        int i = 0;
        while (i < nbNotes) {
            note = String.valueOf(note) + this.readStringIntegerPlusOne();
            note = String.valueOf(note) + "\n";
            ++i;
        }
        piece.setNote(note);
        piece.tripletFeel = this.readBoolean();
        GPTrackLyrics lyrics = new GPTrackLyrics();
        lyrics.setTrackNumber(this.readInt());
        int i2 = 0;
        while (i2 < 5) {
            lyrics.setMeasureNumber(i2, this.readInt());
            lyrics.setLine(i2, this.readStringInteger());
            ++i2;
        }
        piece.setLyrics(lyrics);
        int tempo = this.readInt();
        piece.setTempo(tempo);
        GPKey key = GPKey.valueOf(this.readByte());
        piece.setKey(key);
        int octave = this.readInt();
        piece.setOctave(octave);
        int i3 = 0;
        while (i3 < 64) {
            GPMIDIChannel channel = this.readMIDIChannel();
            piece.setChannels(i3, channel);
            ++i3;
        }
        int numberOfMeasures = this.readInt();
        int numberOfTracks = this.readInt();
        List measures = piece.getMeasures();
        if (numberOfMeasures > 0) {
            GPMeasure measure = this.readMeasure(null);
            measure.setNumber(1);
            measures.add(measure);
            int i4 = 1;
            while (i4 < numberOfMeasures) {
                GPMeasure previous = (GPMeasure)measures.get(i4 - 1);
                measure = this.readMeasure(previous);
                measure.setNumber(i4 + 1);
                measures.add(measure);
                ++i4;
            }
        }
        List tracks = piece.getTracks();
        int i5 = 0;
        while (i5 < numberOfTracks) {
            tracks.add(this.readTrack());
            ++i5;
        }
        List measuresTracksPairs = piece.getMeasuresTracksPairs();
        int i6 = 0;
        while (i6 < numberOfMeasures) {
            int j = 0;
            while (j < numberOfTracks) {
                GPMeasureTrackPair mtp = this.readMeasureTrackPair();
                measuresTracksPairs.add(mtp);
                ++j;
            }
            ++i6;
        }
        return piece;
    }

    private GPBeat readBeat() throws IOException, GPFormatException {
        GPBeat beat = new GPBeat();
        int header = this.readUnsignedByte();
        if ((header & 0x40) != 0) {
            int beatStatus = this.readUnsignedByte();
            beat.setEmptyBeat(beatStatus == 0);
            beat.setRestBeat(beatStatus == 2);
        }
        beat.dottedNotes = (header & 1) != 0;
        GPDuration duration = GPDuration.valueOf(this.readByte());
        beat.setDuration(duration);
        if ((header & 0x20) != 0) {
            int n = this.readInt();
            beat.setNTuplet(n);
        }
        if ((header & 2) != 0) {
            GPChordDiagram CD;
            beat.chordDiagram = CD = this.readChordDiagram();
        }
        if ((header & 4) != 0) {
            beat.text = this.readStringIntegerPlusOne();
        }
        if ((header & 8) != 0) {
            beat.effects = this.readEffectsOnBeat();
        }
        if ((header & 0x10) != 0) {
            beat.mixTableChange = this.readMixTableChange();
        }
        int stringsPlayed = this.readUnsignedByte();
        int numberOfStrings = 0;
        int i = 0;
        while (i < 7) {
            if ((stringsPlayed & 1 << i) != 0) {
                ++numberOfStrings;
                beat.setString(i, true);
            }
            ++i;
        }
        List notes = beat.getNotes();
        int i2 = 0;
        while (i2 < numberOfStrings) {
            GPNote note = this.readNote();
            notes.add(note);
            ++i2;
        }
        return beat;
    }

    private GPColor readColor() throws IOException {
        GPColor color = new GPColor();
        color.red = this.readUnsignedByte();
        color.green = this.readUnsignedByte();
        color.blue = this.readUnsignedByte();
        this.read();
        return color;
    }

    private GPMarker readMarker() throws IOException {
        GPMarker marker = new GPMarker();
        marker.setName(this.readStringIntegerPlusOne());
        marker.setColor(this.readColor());
        return marker;
    }

    private GPMeasure readMeasure(GPMeasure previous) throws IOException {
        GPMeasure measure = new GPMeasure(previous);
        int header = this.readUnsignedByte();
        if ((header & 1) != 0) {
            measure.setNumerator(this.readByte());
        }
        if ((header & 2) != 0) {
            measure.setDenominator(this.readByte());
        }
        boolean bl = measure.repeatStart = (header & 4) != 0;
        if ((header & 8) != 0) {
            measure.setNumberOfRepetitions(this.readByte());
        }
        if ((header & 0x10) != 0) {
            measure.setNumberOfAlternateEnding(this.readByte());
        }
        if ((header & 0x20) != 0) {
            measure.marker = this.readMarker();
        }
        if ((header & 0x40) != 0) {
            byte type = this.readByte();
            GPKey key = GPKey.valueOf(this.readByte(), type);
            measure.setTonality(key);
        }
        measure.hasDoubleBar = (header & 0x80) != 0;
        return measure;
    }

    private GPMeasureTrackPair readMeasureTrackPair() throws IOException, GPFormatException {
        GPMeasureTrackPair mtp = new GPMeasureTrackPair();
        List beats = mtp.getBeats();
        int numberOfBeats = this.readInt();
        int i = 0;
        while (i < numberOfBeats) {
            GPBeat beat = this.readBeat();
            beats.add(beat);
            ++i;
        }
        return mtp;
    }

    private GPMIDIChannel readMIDIChannel() throws IOException {
        GPMIDIChannel channel = new GPMIDIChannel();
        byte[] b = new byte[2];
        channel.setInstrument(this.readInt());
        channel.setVolume(this.readByte());
        channel.setBalance(this.readByte());
        channel.setChorus(this.readByte());
        channel.setReverb(this.readByte());
        channel.setPhaser(this.readByte());
        channel.setTremolo(this.readByte());
        this.read(b);
        return channel;
    }

    private GPNote readNote() throws IOException {
        GPNote note = new GPNote();
        int header = this.readUnsignedByte();
        note.isAccentuated = (header & 0x40) != 0;
        note.isDotted = (header & 2) != 0;
        note.setGhostNote((header & 4) != 0);
        if ((header & 0x20) != 0) {
            int noteType = this.readUnsignedByte();
            note.setTieNote(noteType == 2);
            note.setDeadNote(noteType == 3);
        }
        if ((header & 1) != 0) {
            try {
                note.duration = GPDuration.valueOf(this.readByte());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            note.setNTuplet(this.readByte());
        }
        if ((header & 0x10) != 0) {
            note.setDynamic(GPDynamic.valueOf(this.readByte()));
        }
        if ((header & 0x20) != 0) {
            note.setFretNumber(this.readByte());
        }
        if ((header & 0x80) != 0) {
            note.fingeringLeftHand = GPFingering.valueOf(this.readByte());
            note.fingeringRightHand = GPFingering.valueOf(this.readByte());
        }
        if ((header & 8) != 0) {
            note.effects = this.readEffectsOnNote();
        }
        return note;
    }

    private GPTrack readTrack() throws IOException {
        GPTrack track = new GPTrack();
        int header = this.readUnsignedByte();
        track.isDrumsTrack = (header & 1) != 0;
        track.is12StringedGuitarTrack = (header & 2) != 0;
        track.isBanjoTrack = (header & 4) != 0;
        track.setName(this.readStringByte(40));
        track.setNumberOfStrings(this.readInt());
        int i = 0;
        while (i < 7) {
            track.setStringsTuning(i, this.readInt());
            ++i;
        }
        track.setPort(this.readInt());
        track.setChannel(this.readInt());
        track.setChannelEffects(this.readInt());
        track.setNumberOfFrets(this.readInt());
        track.setCapo(this.readInt());
        track.setColor(this.readColor());
        return track;
    }

    private GPChordType readChordType() throws IOException {
        return GPChordType.valueOf(this.readUnsignedByte());
    }

    private GPChordNote readRoot() throws IOException {
        return GPChordNote.valueOf(this.readByte());
    }

    private GPTonalityType readTonalityType(int numBytes) throws IOException {
        GPTonalityType TT = null;
        if (numBytes == 1) {
            TT = GPTonalityType.valueOf(this.readUnsignedByte());
        } else if (numBytes == 4) {
            TT = GPTonalityType.valueOf(this.readInt());
        }
        return TT;
    }

    private GPChordDiagram readChordDiagram() throws IOException, GPFormatException {
        GPChordDiagram CD = new GPChordDiagram();
        int header = this.readUnsignedByte();
        if ((header & 1) == 0) {
            String cad = "\nChord Diagrams are in GP3 format";
            cad = String.valueOf(cad) + "\nWhich are not documented";
            cad = String.valueOf(cad) + "\nWe are working on this";
            throw new GP4FormatException(cad);
        }
        CD.setSharp(this.readBoolean());
        this.skip(3L);
        CD.setRoot(this.readRoot());
        CD.setChordType(this.readChordType());
        CD.setNineElevenThirteen(this.readUnsignedByte());
        CD.setBass(GPChordNote.valueOf(this.readInt()));
        CD.setTonalityType(this.readTonalityType(4));
        CD.setAddedNote(this.readUnsignedByte());
        CD.setName(this.readStringByte(20));
        this.skip(2L);
        CD.setTonalityFive(this.readTonalityType(1));
        CD.setTonalityNine(this.readTonalityType(1));
        CD.setTonalityEleven(this.readTonalityType(1));
        CD.setBaseFret(this.readInt());
        int i = 1;
        while (i <= 7) {
            CD.setFret(i, this.readInt());
            ++i;
        }
        CD.setNumBarres(this.readUnsignedByte());
        i = 1;
        while (i <= 5) {
            CD.setFretOfBarre(i, this.readUnsignedByte());
            ++i;
        }
        i = 1;
        while (i <= 5) {
            CD.setBarreStart(i, this.readUnsignedByte());
            ++i;
        }
        i = 1;
        while (i <= 5) {
            CD.setBarreEnd(i, this.readUnsignedByte());
            ++i;
        }
        this.skip(8L);
        i = 1;
        while (i <= 7) {
            CD.setFingering(i, this.readByte());
            ++i;
        }
        CD.setchordFingeringDisplayed(this.readBoolean());
        return CD;
    }

    private GPGraceNote readGraceNote() throws IOException {
        byte[] b = new byte[4];
        GPGraceNote GN = new GPGraceNote();
        int i = 0;
        while (i < 4) {
            b[i] = (byte)this.readUnsignedByte();
            ++i;
        }
        GN.setFret(b[0]);
        GN.setDynamic(GPDynamic.valueOf(b[1]));
        GN.setTransition(GPGraceNoteTransition.valueOf(b[2]));
        GN.setDuration(GPDuration.valueOf(3 - b[3]));
        return GN;
    }

    private GPBendPoint readBendPoint() throws IOException {
        GPBendPoint bendPoint = new GPBendPoint();
        bendPoint.setPosition(this.readInt());
        bendPoint.setValue(this.readInt());
        GPVibrato vibrato = GPVibrato.valueOf(this.readByte());
        bendPoint.setVibrato(vibrato);
        return bendPoint;
    }

    private GPBend readBend() throws IOException {
        GPBend bend = new GPBend();
        GPBendType type = GPBendType.valueOf(this.readByte());
        bend.setType(type);
        bend.setValue(this.readInt());
        int numPoints = this.readInt();
        List points = bend.getPoints();
        int i = 0;
        while (i < numPoints) {
            points.add(this.readBendPoint());
            ++i;
        }
        return bend;
    }

    private GPEffectsOnNote readEffectsOnNote() throws IOException {
        GPEffectsOnNote EON = new GPEffectsOnNote();
        int header1 = this.readUnsignedByte();
        int header2 = this.readUnsignedByte();
        if ((header1 & 1) != 0) {
            EON.bend = this.readBend();
        }
        if ((header1 & 0x10) != 0) {
            EON.graceNote = this.readGraceNote();
        }
        if ((header2 & 4) != 0) {
            EON.tremoloPicking = GPDuration.valueOf(this.readUnsignedByte());
        }
        if ((header2 & 8) != 0) {
            EON.slide = GPSlide.valueOf(this.readByte());
        }
        if ((header2 & 0x10) != 0) {
            byte b = this.readByte();
            EON.harmonic = GPHarmonic.valueOf(b);
        }
        if ((header2 & 0x20) != 0) {
            EON.trill = new GPTrill();
            EON.trill.setFret(this.readByte());
            EON.trill.setPeriod(GPDuration.valueOf(this.readByte()));
        }
        if ((header1 & 8) != 0) {
            EON.letRing = true;
        }
        if ((header1 & 2) != 0) {
            EON.hammerOnPullOff = true;
        }
        if ((header2 & 0x40) != 0) {
            EON.leftHandVibrato = true;
        }
        if ((header2 & 2) != 0) {
            EON.palmMute = true;
        }
        if ((header2 & 1) != 0) {
            EON.staccato = true;
        }
        return EON;
    }

    private GPEffectsOnBeat readEffectsOnBeat() throws IOException {
        GPEffectsOnBeat eob = new GPEffectsOnBeat();
        int[] header = new int[]{this.readUnsignedByte(), this.readUnsignedByte()};
        if ((header[0] & 0x20) != 0) {
            int effect = this.readUnsignedByte();
            switch (effect) {
                case 0: {
                    break;
                }
                case 1: {
                    eob.tapping = true;
                    break;
                }
                case 2: {
                    eob.slapping = true;
                    break;
                }
                case 3: {
                    eob.popping = true;
                    break;
                }
                default: {
                    throw new IOException("Unexpected value in effect: " + effect);
                }
            }
        }
        if ((header[1] & 4) != 0) {
            eob.tremoloBar = this.readBend();
        }
        if ((header[0] & 0x40) != 0) {
            byte durationValue = this.readByte();
            if (durationValue != 0) {
                eob.upStroke = GPDuration.valueOf(6 - durationValue);
            }
            if ((durationValue = this.readByte()) != 0) {
                eob.downStroke = GPDuration.valueOf(6 - durationValue);
            }
        }
        if ((header[1] & 1) != 0) {
            eob.hasRasgueado = true;
        }
        if ((header[1] & 2) != 0) {
            eob.pickStrokes = GPPickStroke.valueOf(this.readByte());
        }
        return eob;
    }

    private GPMixTableChange readMixTableChange() throws IOException {
        int aux;
        int[] pos = new int[8];
        GPMixTableChange mtc = new GPMixTableChange();
        GPMixTableElement[] elements = new GPMixTableElement[8];
        int i = 0;
        while (i < 8) {
            elements[i] = new GPMixTableElement();
            ++i;
        }
        mtc.instrument = elements[0];
        mtc.volume = elements[1];
        mtc.balance = elements[2];
        mtc.chorus = elements[3];
        mtc.reverb = elements[4];
        mtc.phaser = elements[5];
        mtc.tremolo = elements[6];
        mtc.tempo = elements[7];
        int n = 0;
        i = 0;
        while (i < 7) {
            aux = this.readByte();
            if (i != 0 && aux != -1) {
                pos[n] = i;
                ++n;
            }
            elements[i].setNewValue(aux);
            ++i;
        }
        aux = this.readInt();
        if (aux != -1) {
            pos[n] = i;
            ++n;
        }
        elements[7].setNewValue(aux);
        i = 0;
        while (i < n) {
            aux = this.readByte();
            if (elements[pos[i]].getNewValue() != -1) {
                elements[pos[i]].setChangeDuration(aux);
            }
            ++i;
        }
        int applyToAllTracks = this.readUnsignedByte();
        i = 0;
        while (i < 6) {
            if ((applyToAllTracks & 1 << i) != 0) {
                elements[i + 1].applyToAllTracks = true;
            }
            ++i;
        }
        elements[7].applyToAllTracks = true;
        return mtc;
    }
}

